/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ExpressionChangeEvent;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ExpressionChangeHandler;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ExpressionTypeChangeEvent;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ExpressionTypeChangeHandler;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.HasExpressionChangeHandlers;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.HasExpressionTypeChangeHandlers;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ExpressionCollectionIndex;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFieldVariable;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFormLine;
import org.drools.ide.common.client.modeldriven.brl.ExpressionMethod;
import org.drools.ide.common.client.modeldriven.brl.ExpressionPart;
import org.drools.ide.common.client.modeldriven.brl.ExpressionPartHelper;
import org.drools.ide.common.client.modeldriven.brl.ExpressionText;
import org.drools.ide.common.client.modeldriven.brl.ExpressionVariable;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;

public class ExpressionBuilder
extends RuleModellerWidget
implements HasExpressionTypeChangeHandlers,
HasExpressionChangeHandlers {
    private static final String DELETE_VALUE = "_delete_";
    private static final String FIElD_VALUE_PREFIX = "fl";
    private static final String VARIABLE_VALUE_PREFIX = "va";
    private static final String GLOBAL_VARIABLE_VALUE_PREFIX = "gv";
    private static final String METHOD_VALUE_PREFIX = "mt";
    private final SmallLabelClickHandler slch = new SmallLabelClickHandler();
    private HorizontalPanel panel = new HorizontalPanel();
    private ExpressionFormLine expression;
    private boolean readOnly;
    private boolean isFactTypeKnown;

    public ExpressionBuilder(RuleModeller modeller, EventBus eventBus, ExpressionFormLine expression) {
        this(modeller, eventBus, expression, false);
    }

    public ExpressionBuilder(RuleModeller modeller, EventBus eventBus, ExpressionFormLine expression, Boolean readOnly) {
        super(modeller, eventBus);
        this.expression = expression;
        this.isFactTypeKnown = this.expression.isEmpty() ? true : this.getModeller().getSuggestionCompletions().containsFactType(this.getModeller().getSuggestionCompletions().getFactNameFromType(this.expression.getRootExpression().getClassType()));
        this.readOnly = readOnly == null ? !this.isFactTypeKnown : readOnly;
        this.panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        StringBuilder bindingLabel = new StringBuilder();
        String binding = this.getBoundText();
        if (binding != null && !binding.equals("")) {
            bindingLabel.append("<b>");
            bindingLabel.append(this.getBoundText());
            bindingLabel.append("</b>");
        }
        bindingLabel.append(expression.getText(false));
        if (expression == null || expression.isEmpty()) {
            if (this.readOnly) {
                this.panel.add((Widget)new SmallLabel("<b>-</b>"));
            } else {
                this.panel.add(this.createStartPointWidget());
            }
        } else if (this.readOnly) {
            this.panel.add((Widget)this.createWidgetForExpression(bindingLabel.toString()));
        } else {
            bindingLabel.append(".");
            this.panel.add((Widget)this.createWidgetForExpression(bindingLabel.toString()));
            this.panel.add(this.getWidgetForCurrentType());
        }
        this.initWidget((Widget)this.panel);
    }

    private String getBoundText() {
        if (this.expression.isBound()) {
            return "[" + this.expression.getBinding() + "] ";
        }
        return "";
    }

    private Widget createStartPointWidget() {
        ListBox startPoint = new ListBox();
        this.panel.add((Widget)startPoint);
        startPoint.addItem(Constants.INSTANCE.ChooseDotDotDot(), "");
        for (String gv : this.getCompletionEngine().getGlobalVariables()) {
            startPoint.addItem(gv, "gv." + gv);
        }
        for (String v : this.getRuleModel().getAllLHSVariables()) {
            startPoint.addItem(v, "va." + v);
        }
        startPoint.setVisibleItemCount(1);
        startPoint.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ListBox lb = (ListBox)event.getSource();
                int index = lb.getSelectedIndex();
                if (index > 0) {
                    ExpressionBuilder.this.makeDirty();
                    ExpressionBuilder.this.startPointChange(lb.getValue(index));
                }
            }
        });
        return startPoint;
    }

    public void makeDirty() {
        super.makeDirty();
        this.setModified(true);
    }

    private void startPointChange(String value) {
        this.setModified(true);
        this.panel.clear();
        int dotPos = value.indexOf(46);
        String prefix = value.substring(0, dotPos);
        String attrib = value.substring(dotPos + 1);
        if (prefix.equals(VARIABLE_VALUE_PREFIX)) {
            ExpressionVariable variable;
            FactPattern fact = this.getRuleModel().getLHSBoundFact(attrib);
            if (fact != null) {
                variable = new ExpressionVariable(fact);
            } else {
                String lhsBindingType = this.getRuleModel().getLHSBindingType(attrib);
                variable = new ExpressionFieldVariable(attrib, lhsBindingType);
            }
            this.expression.appendPart((ExpressionPart)variable);
        } else if (prefix.equals(GLOBAL_VARIABLE_VALUE_PREFIX)) {
            this.expression.appendPart(ExpressionPartHelper.getExpressionPartForGlobalVariable((SuggestionCompletionEngine)this.getCompletionEngine(), (String)attrib));
        }
        Widget w = this.getWidgetForCurrentType();
        if (!this.expression.isEmpty()) {
            this.panel.add((Widget)this.createWidgetForExpression(this.expression.getText() + "."));
        }
        if (w != null) {
            this.panel.add(w);
        }
        this.fireExpressionChangeEvent();
        this.fireExpressionTypeChangeEvent();
    }

    private Widget getWidgetForCurrentType() {
        if (this.expression.isEmpty()) {
            return this.createStartPointWidget();
        }
        ChangeHandler ch = new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ListBox box = (ListBox)event.getSource();
                ExpressionBuilder.this.panel.remove((Widget)box);
                if (box.getSelectedIndex() > 0) {
                    ExpressionBuilder.this.onChangeSelection(box.getValue(box.getSelectedIndex()));
                }
            }
        };
        ListBox lb = new ListBox();
        lb.setVisibleItemCount(1);
        lb.addItem(Constants.INSTANCE.ChooseDotDotDot(), "");
        lb.addItem("<==" + Constants.INSTANCE.DeleteItem(), DELETE_VALUE);
        for (Map.Entry<String, String> entry : this.getCompletionsForCurrentType(this.expression.getParts().size() > 1).entrySet()) {
            lb.addItem(entry.getKey(), entry.getValue());
        }
        lb.addChangeHandler(ch);
        return lb;
    }

    private void onCollectionChange(String value) {
        if ("size".contains(value)) {
            this.expression.appendPart((ExpressionPart)new ExpressionMethod("size", "int", "Integer"));
        } else if ("isEmpty".equals(value)) {
            this.expression.appendPart((ExpressionPart)new ExpressionMethod("isEmpty", "boolean", "Boolean"));
        } else {
            String factName = this.getCompletionEngine().getFactNameFromType(this.getCurrentParametricType());
            ExpressionCollectionIndex collectionIndex = this.getCurrentParametricType() != null && factName != null ? new ExpressionCollectionIndex("get", this.getCurrentParametricType(), factName) : new ExpressionCollectionIndex("get", "java.lang.Object", "Object");
            if ("first".equals(value)) {
                collectionIndex.putParam("index", new ExpressionFormLine((ExpressionPart)new ExpressionText("0")));
                this.expression.appendPart((ExpressionPart)collectionIndex);
            } else if ("last".equals(value)) {
                ExpressionFormLine index = new ExpressionFormLine(this.expression);
                index.appendPart((ExpressionPart)new ExpressionMethod("size", "int", "Integer"));
                index.appendPart((ExpressionPart)new ExpressionText("-1"));
                collectionIndex.putParam("index", index);
                this.expression.appendPart((ExpressionPart)collectionIndex);
            }
        }
    }

    private void onChangeSelection(String value) {
        this.setModified(true);
        String oldType = this.getCurrentGenericType();
        String prevFactName = null;
        if (DELETE_VALUE.equals(value)) {
            this.expression.removeLast();
        } else if ("Collection".equals(this.getCurrentGenericType())) {
            this.onCollectionChange(value);
        } else if ("String".equals(this.getCurrentGenericType())) {
            if ("size".equals(value)) {
                this.expression.appendPart((ExpressionPart)new ExpressionMethod("size", "int", "Integer"));
            } else if ("isEmpty".equals(value)) {
                this.expression.appendPart((ExpressionPart)new ExpressionText(".size() == 0", "", "Integer"));
            }
        } else {
            int dotPos = value.indexOf(46);
            String prefix = value.substring(0, dotPos);
            String attrib = value.substring(dotPos + 1);
            prevFactName = this.getCompletionEngine().getFactNameFromType(this.getCurrentClassType());
            if (FIElD_VALUE_PREFIX.equals(prefix)) {
                this.expression.appendPart(ExpressionPartHelper.getExpressionPartForField((SuggestionCompletionEngine)this.getCompletionEngine(), (String)prevFactName, (String)attrib));
            } else if (METHOD_VALUE_PREFIX.equals(prefix)) {
                this.expression.appendPart(ExpressionPartHelper.getExpressionPartForMethod((SuggestionCompletionEngine)this.getCompletionEngine(), (String)prevFactName, (String)attrib));
            }
        }
        Widget w = this.getWidgetForCurrentType();
        this.panel.clear();
        if (!this.expression.isEmpty()) {
            this.panel.add((Widget)this.createWidgetForExpression(this.expression.getText() + "."));
        }
        if (w != null) {
            this.panel.add(w);
        }
        this.fireExpressionChangeEvent();
        this.fireExpressionTypeChangeEvent(oldType);
    }

    private Map<String, String> getCompletionsForCurrentType(boolean isNested) {
        LinkedHashMap<String, String> completions = new LinkedHashMap<String, String>();
        if ("FinalObject".equals(this.getCurrentGenericType())) {
            return completions;
        }
        if ("Collection".equals(this.getCurrentGenericType())) {
            completions.put("size()", "size");
            completions.put("first()", "first");
            completions.put("last()", "last");
            completions.put("isEmpty()", "isEmpty");
            return completions;
        }
        if ("String".equals(this.getCurrentGenericType())) {
            completions.put("size()", "size");
            completions.put("isEmpty()", "isEmpty");
            return completions;
        }
        if ("Boolean".equals(this.getCurrentGenericType()) || "BigDecimal".equals(this.getCurrentGenericType()) || "BigInteger".equals(this.getCurrentGenericType()) || "Byte".equals(this.getCurrentGenericType()) || "Double".equals(this.getCurrentGenericType()) || "Float".equals(this.getCurrentGenericType()) || "Integer".equals(this.getCurrentGenericType()) || "Long".equals(this.getCurrentGenericType()) || "Short".equals(this.getCurrentGenericType()) || "Date".equals(this.getCurrentGenericType()) || "Object".equals(this.getCurrentGenericType())) {
            return completions;
        }
        String factName = this.getCompletionEngine().getFactNameFromType(this.getCurrentClassType());
        if (factName != null) {
            List methodNames = this.getCompletionEngine().getMethodFullNames(factName, 0);
            for (String field : this.getCompletionEngine().getFieldCompletions(factName)) {
                if (isNested && field.equals("this")) continue;
                boolean changed = false;
                Iterator i = methodNames.iterator();
                while (i.hasNext()) {
                    String method = (String)i.next();
                    if (!method.startsWith(field)) continue;
                    completions.put(method, "mt." + method);
                    i.remove();
                    changed = true;
                }
                if (changed) continue;
                completions.put(field, "fl." + field);
            }
        }
        return completions;
    }

    private RuleModel getRuleModel() {
        return this.getModeller().getModel();
    }

    private SuggestionCompletionEngine getCompletionEngine() {
        return this.getModeller().getSuggestionCompletions();
    }

    private String getCurrentClassType() {
        return this.expression.getClassType();
    }

    private String getCurrentGenericType() {
        return this.expression.getGenericType();
    }

    private String getPreviousGenericType() {
        return this.expression.getPreviousGenericType();
    }

    private String getCurrentParametricType() {
        return this.expression.getParametricType();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }

    @Override
    public HandlerRegistration addExpressionTypeChangeHandler(ExpressionTypeChangeHandler handler) {
        return this.addHandler(handler, ExpressionTypeChangeEvent.getType());
    }

    private void fireExpressionChangeEvent() {
        this.fireEvent(new ExpressionChangeEvent());
    }

    private void fireExpressionTypeChangeEvent() {
        this.fireExpressionTypeChangeEvent(this.getPreviousGenericType());
    }

    private void fireExpressionTypeChangeEvent(String previousGenericType) {
        String currentGenericType = this.getCurrentGenericType();
        if (previousGenericType == null || !previousGenericType.equals(currentGenericType) || currentGenericType != null) {
            this.fireEvent(new ExpressionTypeChangeEvent(previousGenericType, currentGenericType));
        }
    }

    @Override
    public HandlerRegistration addExpressionChangeHandler(ExpressionChangeHandler handler) {
        return this.addHandler(handler, ExpressionChangeEvent.getType());
    }

    private void showBindingPopUp() {
        final FormStylePopup popup = new FormStylePopup();
        popup.setWidth("500px");
        HorizontalPanel vn = new HorizontalPanel();
        final TextBox varName = new TextBox();
        Button ok = new Button(Constants.INSTANCE.Set());
        vn.add((Widget)new Label(Constants.INSTANCE.BindTheExpressionToAVariable()));
        vn.add((Widget)varName);
        vn.add((Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String var = varName.getText();
                if (ExpressionBuilder.this.getModeller().isVariableNameUsed(var)) {
                    Window.alert((String)Constants.INSTANCE.TheVariableName0IsAlreadyTaken(var));
                    return;
                }
                ExpressionBuilder.this.expression.setBinding(var);
                ExpressionBuilder.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        popup.addRow((Widget)vn);
        popup.show();
    }

    private ClickableLabel createWidgetForExpression(String text) {
        ClickableLabel label = new ClickableLabel(text, (ClickHandler)this.slch, !this.readOnly);
        return label;
    }

    private class SmallLabelClickHandler
    implements ClickHandler {
        private SmallLabelClickHandler() {
        }

        public void onClick(ClickEvent event) {
            ExpressionBuilder.this.showBindingPopUp();
        }
    }
}

