/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.workitem;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.drools.workitem.WorkitemDefinitionElementSelectedListener;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.rpc.WorkItemService;
import org.drools.guvnor.client.rpc.WorkItemServiceAsync;

public class WorkitemDefinitionElementsBrowser
extends Composite {
    private Map<String, String> workitemDefinitionElements;
    private WorkitemDefinitionElementSelectedListener elementSelectedItem;
    private final VerticalPanel mainPanel = new VerticalPanel();

    public WorkitemDefinitionElementsBrowser(WorkitemDefinitionElementSelectedListener elementSelectedItem) {
        this.elementSelectedItem = elementSelectedItem;
        WorkItemServiceAsync workItemService = (WorkItemServiceAsync)GWT.create(WorkItemService.class);
        workItemService.loadWorkitemDefinitionElementData((AsyncCallback)new AsyncCallback<Map<String, String>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Map<String, String> result) {
                WorkitemDefinitionElementsBrowser.this.workitemDefinitionElements = result;
                WorkitemDefinitionElementsBrowser.this.doLayout();
            }
        });
        this.initWidget((Widget)this.mainPanel);
    }

    private void doLayout() {
        this.mainPanel.add((Widget)new HTML("<b>Palette</b>"));
        for (Map.Entry<String, String> entry : this.workitemDefinitionElements.entrySet()) {
            this.mainPanel.add((Widget)new PanelButton(entry.getKey(), entry.getValue()));
        }
        final ListBox importsList = new ListBox();
        importsList.addItem(Constants.INSTANCE.ChooseImportClass());
        importsList.addItem("BooleanDataType", "import org.drools.process.core.datatype.impl.type.BooleanDataType;");
        importsList.addItem("EnumDataType", "import org.drools.process.core.datatype.impl.type.EnumDataType;");
        importsList.addItem("FloatDataType", "import org.drools.process.core.datatype.impl.type.FloatDataType;");
        importsList.addItem("IntegerDataType", "import org.drools.process.core.datatype.impl.type.IntegerDataType;");
        importsList.addItem("ListDataType", "import org.drools.process.core.datatype.impl.type.ListDataType;");
        importsList.addItem("ObjectDataType", "import org.drools.process.core.datatype.impl.type.ObjectDataType;");
        importsList.addItem("StringDataType", "import org.drools.process.core.datatype.impl.type.StringDataType;");
        importsList.addItem("UndefinedDataType", "import org.drools.process.core.datatype.impl.type.UndefinedDataType;");
        importsList.setVisibleItemCount(9);
        importsList.setSelectedIndex(0);
        importsList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (WorkitemDefinitionElementsBrowser.this.elementSelectedItem != null) {
                    WorkitemDefinitionElementsBrowser.this.elementSelectedItem.onElementSelected(importsList.getItemText(importsList.getSelectedIndex()), importsList.getValue(importsList.getSelectedIndex()));
                }
            }
        });
        this.mainPanel.add((Widget)importsList);
        final ListBox imagesList = new ListBox();
        imagesList.addItem(Constants.INSTANCE.ChooseIcon());
        imagesList.setVisibleItemCount(1);
        imagesList.setSelectedIndex(0);
        imagesList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (WorkitemDefinitionElementsBrowser.this.elementSelectedItem != null) {
                    WorkitemDefinitionElementsBrowser.this.elementSelectedItem.onElementSelected(imagesList.getItemText(imagesList.getSelectedIndex()), imagesList.getValue(imagesList.getSelectedIndex()));
                }
            }
        });
        this.mainPanel.add((Widget)imagesList);
        final ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.loadGlobalModule((AsyncCallback)new AsyncCallback<Module>(){

            public void onFailure(Throwable caught) {
                ErrorPopup.showMessage((String)"Error listing Global Area information!");
            }

            public void onSuccess(Module result) {
                final Module presults = result;
                moduleService.listImagesInModule(result.getName(), (AsyncCallback)new AsyncCallback<String[]>(){

                    public void onFailure(Throwable caught) {
                        ErrorPopup.showMessage((String)"Error listing images information!");
                    }

                    public void onSuccess(String[] images) {
                        for (int i = 0; i < images.length; ++i) {
                            imagesList.addItem(presults.getName() + " : " + images[i], ApplicationPreferences.getGuvnorURL() + "/rest/packages/" + presults.getName() + "/assets/" + images[i] + "/binary");
                        }
                    }
                });
            }
        });
        moduleService.listModules((AsyncCallback)new AsyncCallback<Module[]>(){

            public void onFailure(Throwable caught) {
                ErrorPopup.showMessage((String)"Error listing images information!");
            }

            public void onSuccess(Module[] result) {
                for (int i = 0; i < result.length; ++i) {
                    final Module packageConfigData = result[i];
                    moduleService.listImagesInModule(packageConfigData.getName(), (AsyncCallback)new AsyncCallback<String[]>(){

                        public void onFailure(Throwable caught) {
                            ErrorPopup.showMessage((String)"Error listing images information!");
                        }

                        public void onSuccess(String[] images) {
                            for (int i = 0; i < images.length; ++i) {
                                imagesList.addItem(packageConfigData.getName() + " : " + images[i], ApplicationPreferences.getGuvnorURL() + "/rest/packages/" + packageConfigData.getName() + "/assets/" + images[i] + "/binary");
                            }
                        }
                    });
                }
            }
        });
        this.mainPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.mainPanel.setSpacing(10);
    }

    private class LeafClickHandler
    implements ClickHandler {
        private final String title;
        private final String pasteValue;

        public LeafClickHandler(String title, String pasteValue) {
            this.title = title;
            this.pasteValue = pasteValue;
        }

        public void onClick(ClickEvent event) {
            if (WorkitemDefinitionElementsBrowser.this.elementSelectedItem != null) {
                WorkitemDefinitionElementsBrowser.this.elementSelectedItem.onElementSelected(this.title, this.pasteValue);
            }
        }
    }

    private class PanelButton
    extends Button {
        public PanelButton(String html, String pasteValue) {
            super(html);
            this.setWidth("100px");
            this.addClickHandler(new LeafClickHandler(html, pasteValue));
        }
    }
}

