/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.common.DatePickerTextBox;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.TextBoxFactory;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;

public class VerifyFieldConstraintEditor
extends DirtyableComposite {
    private String factType;
    private VerifyField field;
    private final Panel panel;
    private Scenario scenario;
    private SuggestionCompletionEngine sce;
    private ValueChanged callback;
    private ExecutionTrace executionTrace;

    public VerifyFieldConstraintEditor(String factType, ValueChanged callback, VerifyField field, SuggestionCompletionEngine sce, Scenario scenario, ExecutionTrace executionTrace) {
        this.field = field;
        this.sce = sce;
        this.factType = factType;
        this.callback = callback;
        this.scenario = scenario;
        this.executionTrace = executionTrace;
        this.panel = new SimplePanel();
        this.refreshEditor();
        this.initWidget((Widget)this.panel);
    }

    private void refreshEditor() {
        String key = this.factType + "." + this.field.getFieldName();
        String flType = this.sce.getFieldType(key);
        this.panel.clear();
        if (flType != null && flType.equals("Boolean")) {
            String[] c = new String[]{"true", "false"};
            this.panel.add((Widget)new EnumDropDown(this.field.getExpected(), new DropDownValueChanged(){

                public void valueChanged(String newText, String newValue) {
                    VerifyFieldConstraintEditor.this.callback.valueChanged(newValue);
                }
            }, DropDownData.create((String[])c)));
        } else if (flType != null && flType.equals("Date")) {
            DatePickerTextBox datePicker = new DatePickerTextBox(this.field.getExpected());
            String m = Constants.INSTANCE.ValueFor0(this.field.getFieldName());
            datePicker.setTitle(m);
            datePicker.addValueChanged(new ValueChanged(){

                public void valueChanged(String newValue) {
                    VerifyFieldConstraintEditor.this.field.setExpected(newValue);
                }
            });
            this.panel.add((Widget)datePicker);
        } else {
            HashMap currentValueMap = new HashMap();
            DropDownData dropDownData = this.sce.getEnums(this.factType, this.field.getFieldName(), currentValueMap);
            if (dropDownData != null) {
                String dataType = this.sce.getFieldType(key);
                if (dataType.equals("Comparable")) {
                    this.field.setNature(4L);
                } else {
                    this.field.setNature(1L);
                }
                this.panel.add((Widget)new EnumDropDown(this.field.getExpected(), new DropDownValueChanged(){

                    public void valueChanged(String newText, String newValue) {
                        VerifyFieldConstraintEditor.this.callback.valueChanged(newValue);
                    }
                }, dropDownData));
            } else {
                if (this.field.getExpected() != null && this.field.getExpected().length() > 0 && this.field.getNature() == 0L) {
                    if (this.field.getExpected().charAt(0) == '=') {
                        this.field.setNature(2L);
                    } else {
                        this.field.setNature(1L);
                    }
                }
                if (this.field.getNature() == 0L && this.isThereABoundVariableToSet()) {
                    Image clickme = GuvnorImages.INSTANCE.Edit();
                    clickme.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            VerifyFieldConstraintEditor.this.showTypeChoice((Widget)event.getSource(), VerifyFieldConstraintEditor.this.field);
                        }
                    });
                    this.panel.add((Widget)clickme);
                } else if (this.field.getNature() == 2L) {
                    this.panel.add(this.variableEditor());
                } else {
                    this.panel.add((Widget)VerifyFieldConstraintEditor.editableTextBox(this.callback, flType, this.field.getFieldName(), this.field.getExpected()));
                }
            }
        }
    }

    private Widget variableEditor() {
        List vars = this.scenario.getFactNamesInScope(this.executionTrace, true);
        final ListBox box = new ListBox();
        if (this.field.getExpected() == null) {
            box.addItem(Constants.INSTANCE.Choose());
        }
        int j = 0;
        for (int i = 0; i < vars.size(); ++i) {
            String var = (String)vars.get(i);
            FactData f = (FactData)this.scenario.getFactTypes().get(var);
            String fieldType = this.sce.getFieldType(this.factType, this.field.getFieldName());
            if (!f.getType().equals(fieldType)) continue;
            if (box.getItemCount() == 0) {
                box.addItem("...");
                ++j;
            }
            box.addItem("=" + var);
            if (this.field.getExpected() != null && this.field.getExpected().equals("=" + var)) {
                box.setSelectedIndex(j);
            }
            ++j;
        }
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                VerifyFieldConstraintEditor.this.field.setExpected(box.getItemText(box.getSelectedIndex()));
            }
        });
        return box;
    }

    private static TextBox editableTextBox(final ValueChanged changed, String dataType, String fieldName, String initialValue) {
        final TextBox tb = TextBoxFactory.getTextBox(dataType);
        tb.setText(initialValue);
        String m = Constants.INSTANCE.ValueFor0(fieldName);
        tb.setTitle(m);
        tb.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                changed.valueChanged(tb.getText());
            }
        });
        return tb;
    }

    private void showTypeChoice(Widget w, final VerifyField con) {
        final FormStylePopup form = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.FieldValue());
        Button lit = new Button(Constants.INSTANCE.LiteralValue());
        lit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                con.setNature(1L);
                VerifyFieldConstraintEditor.this.doTypeChosen(form);
            }
        });
        form.addAttribute(Constants.INSTANCE.LiteralValue() + ":", (Widget)this.widgets((Widget)lit, (Widget)new InfoPopup(Constants.INSTANCE.LiteralValue(), Constants.INSTANCE.LiteralValTip())));
        form.addRow((Widget)new HTML("<hr/>"));
        form.addRow((Widget)new SmallLabel(Constants.INSTANCE.AdvancedOptions()));
        Button variable = new Button(Constants.INSTANCE.BoundVariable());
        variable.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                con.setNature(2L);
                VerifyFieldConstraintEditor.this.doTypeChosen(form);
            }
        });
        form.addAttribute(Constants.INSTANCE.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(Constants.INSTANCE.ABoundVariable(), Constants.INSTANCE.BoundVariableTip())));
        form.show();
    }

    private boolean isThereABoundVariableToSet() {
        boolean retour = false;
        List vars = this.scenario.getFactNamesInScope(this.executionTrace, true);
        if (vars.size() > 0) {
            for (int i = 0; i < vars.size(); ++i) {
                String var = (String)vars.get(i);
                FactData f = (FactData)this.scenario.getFactTypes().get(var);
                String fieldType = this.sce.getFieldType(this.factType, this.field.getFieldName());
                if (!f.getType().equals(fieldType)) continue;
                retour = true;
                break;
            }
        }
        return retour;
    }

    private void doTypeChosen(FormStylePopup form) {
        this.refreshEditor();
        form.hide();
    }

    private Panel widgets(Widget left, Widget right) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.add(left);
        panel.add(right);
        panel.setWidth("100%");
        return panel;
    }
}

