/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.ruleeditor.workitem;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.ruleeditor.workitem.AbstractWorkDefinitionsLoader;

public class AssetWorkDefinitionsLoader
extends AbstractWorkDefinitionsLoader {
    private RepositoryAssetService repositoryAssetService;
    private String packageUUID;

    public AssetWorkDefinitionsLoader(RepositoryAssetService repositoryAssetService, String packageUUID) {
        this.repositoryAssetService = repositoryAssetService;
        this.packageUUID = packageUUID;
    }

    @Override
    public List<String> loadWorkDefinitions() throws SerializationException {
        AssetPageRequest workDefinitionAssetRequest = new AssetPageRequest(this.packageUUID, Arrays.asList("wid"), null, 0, null);
        PageResponse assetWorkDefinitions = this.repositoryAssetService.findAssetPage(workDefinitionAssetRequest);
        ArrayList<String> definitions = new ArrayList<String>();
        for (AssetPageRow row : assetWorkDefinitions.getPageRowList()) {
            Asset asset = this.repositoryAssetService.loadRuleAsset(row.getUuid());
            RuleContentText content = (RuleContentText)asset.getContent();
            definitions.add(content.content);
        }
        return definitions;
    }
}

