/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.categorynav;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.rpc.CategoryService;
import org.drools.guvnor.client.rpc.CategoryServiceAsync;

public class CategoryEditor
extends FormStylePopup {
    private String path;
    private TextBox name = new TextBox();
    private TextArea description = new TextArea();
    private Command refresh;
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);

    public CategoryEditor(String catPath, Command refresh) {
        this(catPath);
        this.refresh = refresh;
    }

    public CategoryEditor(String catPath) {
        super.setTitle(CategoryEditor.getTitle(catPath));
        this.path = catPath;
        this.addAttribute(this.constants.CategoryName(), (Widget)this.name);
        Button ok = new Button(this.constants.OK());
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CategoryEditor.this.ok();
            }
        });
        this.addAttribute("", (Widget)ok);
    }

    private static String getTitle(String catPath) {
        if (catPath == null) {
            return ((ConstantsCore)GWT.create(ConstantsCore.class)).CreateANewTopLevelCategory();
        }
        return ((ConstantsCore)GWT.create(ConstantsCore.class)).CreateNewCategoryUnder0(catPath);
    }

    void ok() {
        GenericCallback<Boolean> cb = new GenericCallback<Boolean>(){

            public void onSuccess(Boolean booleanValue) {
                if (booleanValue.booleanValue()) {
                    if (CategoryEditor.this.refresh != null) {
                        CategoryEditor.this.refresh.execute();
                    }
                    CategoryEditor.this.hide();
                } else {
                    ErrorPopup.showMessage(CategoryEditor.this.constants.CategoryWasNotSuccessfullyCreated());
                }
            }
        };
        if ("".equals(this.name.getText())) {
            ErrorPopup.showMessage(this.constants.CanNotHaveAnEmptyCategoryName());
        } else {
            CategoryServiceAsync categoryService = (CategoryServiceAsync)GWT.create(CategoryService.class);
            categoryService.createCategory(this.path, this.name.getText(), this.description.getText(), (AsyncCallback<Boolean>)cb);
        }
    }

    void cancel() {
        this.hide();
    }
}

