/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.drools.guvnor.server.repository.GuvnorBootstrapConfiguration;
import org.drools.guvnor.server.repository.RepositoryImportedEvent;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryConfigurator;
import org.drools.repository.RulesRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryStartupService {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    protected GuvnorBootstrapConfiguration guvnorBootstrapConfiguration;
    @Inject
    @Any
    private Event<RepositoryImportedEvent> repositoryImportedEventEvent;
    private RulesRepositoryConfigurator configurator;
    protected Repository repository;
    protected Session sessionForSetup;

    public Repository getRepositoryInstance() {
        Properties properties = new Properties();
        properties.putAll(this.guvnorBootstrapConfiguration.getProperties());
        this.configurator = RulesRepositoryConfigurator.getInstance((Properties)properties);
        this.repository = this.configurator.getJCRRepository();
        return this.repository;
    }

    @PostConstruct
    public void create() {
        this.repository = this.getRepositoryInstance();
        String adminUsername = this.guvnorBootstrapConfiguration.extractAdminUsername();
        String adminPassword = this.guvnorBootstrapConfiguration.extractAdminPassword();
        this.sessionForSetup = this.newSession(adminUsername, adminPassword);
        this.setupRepository(this.sessionForSetup);
    }

    private void setupRepository(Session sessionForSetup) {
        RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(sessionForSetup);
        if (!admin.isRepositoryInitialized()) {
            try {
                this.configurator.setupRepository(sessionForSetup);
            }
            catch (RepositoryException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
        }
        this.repositoryImportedEventEvent.fire((Object)new RepositoryImportedEvent());
    }

    @PreDestroy
    public void close() {
        this.sessionForSetup.logout();
        this.log.info("Shutting down repository...");
        this.configurator.shutdown();
    }

    public Session newSession(String userName) {
        try {
            return this.configurator.login(userName);
        }
        catch (LoginException e) {
            throw new RulesRepositoryException("Unable to login to JCR backend.", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    public Session newSession(String userName, String password) {
        try {
            return this.configurator.login(userName, password);
        }
        catch (LoginException e) {
            throw new RulesRepositoryException("UserName: [ " + userName + "] Unable to login to JCR backend.", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
    }
}

