/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.navigation.admin.widget.WorkspaceEditor;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;

public class WorkspaceManager
extends Composite {
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
    private ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
    private ListBox availableWorkspacesListBox;
    private ListBox availableModulesListBox = new ListBox(true);
    private ListBox selectedModulesListBox = new ListBox(true);

    public WorkspaceManager() {
        PrettyFormLayout form = new PrettyFormLayout();
        form.addHeader(GuvnorImages.INSTANCE.WorkspaceManager(), (Widget)new HTML("<b>" + this.constants.ManageWorkspaces() + "</b>"));
        form.startSection(this.constants.Workspaces());
        form.addAttribute("", (Widget)this.buildDoubleList());
        HorizontalPanel hPanel = new HorizontalPanel();
        Button create = new Button(this.constants.AddWorkspace());
        create.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                WorkspaceEditor newCat = new WorkspaceEditor(new Command(){

                    public void execute() {
                        WorkspaceManager.this.refreshWorkspaceList();
                    }
                });
                newCat.show();
            }
        });
        Button remove = new Button(this.constants.DeleteSelectedWorkspace());
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (WorkspaceManager.this.availableWorkspacesListBox.getSelectedIndex() == -1) {
                    Window.alert((String)WorkspaceManager.this.constants.PleaseSelectAWorkspaceToRemove());
                    return;
                }
                WorkspaceManager.this.removeWorkspace();
            }
        });
        Button updateWorkspace = new Button(this.constants.UpdateSelectedWorkspace());
        updateWorkspace.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (WorkspaceManager.this.availableWorkspacesListBox.getSelectedIndex() == -1) {
                    Window.alert((String)WorkspaceManager.this.constants.PleaseSelectAWorkspaceToUpdate());
                    return;
                }
                WorkspaceManager.this.updateWorkspace();
            }
        });
        hPanel.add((Widget)create);
        hPanel.add((Widget)remove);
        hPanel.add((Widget)updateWorkspace);
        form.addAttribute("", (Widget)hPanel);
        form.endSection();
        this.initWidget((Widget)form);
    }

    private void removeWorkspace() {
        String name = this.availableWorkspacesListBox.getItemText(this.availableWorkspacesListBox.getSelectedIndex());
        this.repositoryService.removeWorkspace(name, new GenericCallback<Void>(){

            public void onSuccess(Void v) {
                Window.alert((String)WorkspaceManager.this.constants.WorkspaceRemoved());
                WorkspaceManager.this.refreshWorkspaceList();
            }
        });
    }

    private void updateWorkspace() {
        String name = this.availableWorkspacesListBox.getItemText(this.availableWorkspacesListBox.getSelectedIndex());
        ArrayList<String> selectedModulesList = new ArrayList<String>(this.selectedModulesListBox.getItemCount());
        for (int i = 0; i < this.selectedModulesListBox.getItemCount(); ++i) {
            selectedModulesList.add(this.selectedModulesListBox.getItemText(i));
        }
        ArrayList<String> availableModuleList = new ArrayList<String>(this.availableModulesListBox.getItemCount());
        for (int i = 0; i < this.availableModulesListBox.getItemCount(); ++i) {
            availableModuleList.add(this.availableModulesListBox.getItemText(i));
        }
        availableModuleList.removeAll(selectedModulesList);
        LoadingPopup.showMessage(this.constants.LoadingStatuses());
        this.repositoryService.updateWorkspace(name, selectedModulesList.toArray(new String[selectedModulesList.size()]), availableModuleList.toArray(new String[availableModuleList.size()]), new GenericCallback<Void>(){

            public void onSuccess(Void v) {
                Window.alert((String)WorkspaceManager.this.constants.WorkspaceUpdated());
                WorkspaceManager.this.refreshWorkspaceList();
            }
        });
    }

    private void refreshWorkspaceList() {
        LoadingPopup.showMessage(this.constants.LoadingWorkspaces());
        this.repositoryService.listWorkspaces((AsyncCallback<String[]>)new GenericCallback<String[]>(){

            public void onSuccess(String[] workspaces) {
                WorkspaceManager.this.availableWorkspacesListBox.clear();
                for (String workspace : workspaces) {
                    WorkspaceManager.this.availableWorkspacesListBox.addItem(workspace);
                }
                LoadingPopup.close();
            }
        });
    }

    private void refreshModuleList(String selectedWorkspaceName) {
        if (selectedWorkspaceName == null || "".equals(selectedWorkspaceName)) {
            return;
        }
        LoadingPopup.showMessage(this.constants.LoadingWorkspaces());
        this.moduleService.listModules(selectedWorkspaceName, (AsyncCallback<Module[]>)new GenericCallback<Module[]>(){

            public void onSuccess(Module[] packageConfigData) {
                WorkspaceManager.this.selectedModulesListBox.clear();
                for (Module p : packageConfigData) {
                    WorkspaceManager.this.selectedModulesListBox.addItem(p.getName());
                }
                LoadingPopup.close();
            }
        });
        LoadingPopup.showMessage(this.constants.LoadingWorkspaces());
        this.moduleService.listModules((AsyncCallback<Module[]>)new GenericCallback<Module[]>(){

            public void onSuccess(Module[] packageConfigData) {
                WorkspaceManager.this.availableModulesListBox.clear();
                for (Module p : packageConfigData) {
                    boolean isSelected = false;
                    for (int i = 0; i < WorkspaceManager.this.selectedModulesListBox.getItemCount(); ++i) {
                        if (!p.getName().equals(WorkspaceManager.this.selectedModulesListBox.getItemText(i))) continue;
                        isSelected = true;
                    }
                    if (isSelected) continue;
                    WorkspaceManager.this.availableModulesListBox.addItem(p.getName());
                }
                LoadingPopup.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grid buildDoubleList() {
        Grid grid = new Grid(2, 5);
        this.availableWorkspacesListBox = new ListBox();
        this.availableWorkspacesListBox.setVisibleItemCount(10);
        this.availableWorkspacesListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent arg0) {
                String selectedWorkspaceName = WorkspaceManager.this.availableWorkspacesListBox.getItemText(WorkspaceManager.this.availableWorkspacesListBox.getSelectedIndex());
                WorkspaceManager.this.refreshModuleList(selectedWorkspaceName);
            }
        });
        this.refreshWorkspaceList();
        this.availableModulesListBox.setVisibleItemCount(10);
        this.selectedModulesListBox.setVisibleItemCount(10);
        Grid btnsPanel = new Grid(2, 1);
        btnsPanel.setWidget(0, 0, (Widget)new Button(">", new ClickHandler(){

            public void onClick(ClickEvent sender) {
                WorkspaceManager.this.copySelected(WorkspaceManager.this.availableModulesListBox, WorkspaceManager.this.selectedModulesListBox);
            }
        }));
        btnsPanel.setWidget(1, 0, (Widget)new Button("&lt;", new ClickHandler(){

            public void onClick(ClickEvent sender) {
                WorkspaceManager.this.copySelected(WorkspaceManager.this.selectedModulesListBox, WorkspaceManager.this.availableModulesListBox);
            }
        }));
        grid.setWidget(0, 0, (Widget)new SmallLabel(this.constants.Workspaces()));
        grid.setWidget(0, 2, (Widget)new SmallLabel("Workspace: Available Modules"));
        grid.setWidget(0, 3, (Widget)new SmallLabel(""));
        grid.setWidget(0, 4, (Widget)new SmallLabel("Workspace: Selected Modules"));
        grid.setWidget(1, 0, (Widget)this.availableWorkspacesListBox);
        grid.setWidget(1, 2, (Widget)this.availableModulesListBox);
        grid.setWidget(1, 3, (Widget)btnsPanel);
        grid.setWidget(1, 4, (Widget)this.selectedModulesListBox);
        grid.getColumnFormatter().setWidth(0, "25%");
        grid.getColumnFormatter().setWidth(1, "10%");
        grid.getColumnFormatter().setWidth(2, "25%");
        grid.getColumnFormatter().setWidth(3, "15%");
        grid.getColumnFormatter().setWidth(4, "25%");
        Grid grid2 = grid;
        return grid2;
    }

    private void copySelected(ListBox from, ListBox to) {
        int selected;
        while ((selected = from.getSelectedIndex()) != -1) {
            to.addItem(from.getItemText(selected));
            from.removeItem(selected);
        }
    }
}

