/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.RefreshModuleEditorEvent;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.moduleeditor.AbstractModuleEditor;
import org.drools.guvnor.client.moduleeditor.ArtifactEditor;
import org.drools.guvnor.client.moduleeditor.AssetViewerActivity;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;

public class ModuleEditorWrapper
extends Composite {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private Module packageConfigData;
    private boolean isHistoricalReadOnly = false;
    VerticalPanel layout = new VerticalPanel();
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public ModuleEditorWrapper(Module data, ClientFactory clientFactory, EventBus eventBus) {
        this(data, clientFactory, eventBus, false);
    }

    public ModuleEditorWrapper(Module data, ClientFactory clientFactory, EventBus eventBus, boolean isHistoricalReadOnly) {
        this.packageConfigData = data;
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.isHistoricalReadOnly = isHistoricalReadOnly;
        this.initWidget((Widget)this.layout);
        this.setRefreshHandler();
        this.render();
        this.setWidth("100%");
    }

    private void render() {
        final TabPanel tPanel = new TabPanel();
        tPanel.setWidth("100%");
        ArtifactEditor artifactEditor = new ArtifactEditor(this.packageConfigData, this.clientFactory, this.eventBus, this.isHistoricalReadOnly);
        Command refreshCommand = new Command(){

            public void execute() {
                ModuleEditorWrapper.this.refresh();
            }
        };
        AbstractModuleEditor moduleEditor = this.clientFactory.getPerspectiveFactory().getModuleEditor(this.packageConfigData, this.clientFactory, this.eventBus, this.isHistoricalReadOnly, refreshCommand);
        this.layout.clear();
        Widget actionToolBar = this.clientFactory.getPerspectiveFactory().getModuleEditorActionToolbar(this.packageConfigData, this.clientFactory, this.eventBus, this.isHistoricalReadOnly, refreshCommand);
        this.layout.add(actionToolBar);
        AssetViewerActivity assetViewerActivity = new AssetViewerActivity(this.packageConfigData.getUuid(), this.clientFactory);
        assetViewerActivity.start(new AcceptItem(){

            @Override
            public void add(String tabTitle, IsWidget widget) {
                ScrollPanel pnl = new ScrollPanel();
                pnl.setWidth("100%");
                pnl.add(widget);
                tPanel.add((Widget)pnl, ModuleEditorWrapper.this.constants.Assets());
            }
        }, null);
        ScrollPanel pnl = new ScrollPanel();
        pnl.setWidth("100%");
        pnl.add((Widget)artifactEditor);
        tPanel.add((Widget)pnl, this.constants.AttributeForModuleEditor());
        tPanel.selectTab(0);
        pnl = new ScrollPanel();
        pnl.setWidth("100%");
        pnl.add((Widget)moduleEditor);
        tPanel.add((Widget)pnl, this.constants.Edit());
        tPanel.selectTab(0);
        tPanel.setHeight("100%");
        this.layout.add((Widget)tPanel);
        this.layout.setHeight("100%");
    }

    public void refresh() {
        LoadingPopup.showMessage(this.constants.RefreshingPackageData());
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.loadModule(this.packageConfigData.getUuid(), (AsyncCallback<Module>)new GenericCallback<Module>(){

            public void onSuccess(Module data) {
                LoadingPopup.close();
                ModuleEditorWrapper.this.packageConfigData = data;
                ModuleEditorWrapper.this.render();
            }
        });
    }

    private void setRefreshHandler() {
        this.eventBus.addHandler(RefreshModuleEditorEvent.TYPE, (EventHandler)new RefreshModuleEditorEvent.Handler(){

            @Override
            public void onRefreshModule(RefreshModuleEditorEvent refreshModuleEditorEvent) {
                String moduleUUID = refreshModuleEditorEvent.getUuid();
                if (moduleUUID != null && moduleUUID.equals(ModuleEditorWrapper.this.packageConfigData.getUuid())) {
                    ModuleEditorWrapper.this.refresh();
                }
            }
        });
    }
}

