/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.guvnor.client.rpc.CategoryPageRequest;
import org.drools.guvnor.client.rpc.CategoryPageRow;
import org.drools.guvnor.client.rpc.CategoryService;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.server.RepositoryCategoryOperations;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.builder.PageResponseBuilder;
import org.drools.guvnor.server.security.CategoryPathType;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.seam.security.annotations.LoggedIn;

@ApplicationScoped
@Named(value="org.drools.guvnor.client.rpc.CategoryService")
public class RepositoryCategoryService
implements CategoryService {
    private static final long serialVersionUID = 12365L;
    @Inject
    private ServiceSecurity serviceSecurity;
    @Inject
    private RepositoryCategoryOperations repositoryCategoryOperations;

    @Override
    @WebRemote
    @LoggedIn
    public String[] loadChildCategories(String categoryPath) {
        return this.repositoryCategoryOperations.loadChildCategories(categoryPath);
    }

    @Override
    @WebRemote
    public Boolean createCategory(String path, String name, String description) {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryCategoryOperations.createCategory(path, name, description);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void renameCategory(String fullPathAndName, String newName) {
        this.repositoryCategoryOperations.renameCategory(fullPathAndName, newName);
    }

    @Override
    @WebRemote
    @LoggedIn
    public TableDataResult loadRuleListForCategories(String categoryPath, int skip, int numRows, String tableConfig) throws SerializationException {
        return this.repositoryCategoryOperations.loadRuleListForCategories(categoryPath, skip, numRows, tableConfig);
    }

    @Override
    @WebRemote
    @LoggedIn
    public PageResponse<CategoryPageRow> loadRuleListForCategories(CategoryPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        if (!this.serviceSecurity.isSecurityIsAnalystReadWithTargetObject(new CategoryPathType(request.getCategoryPath()))) {
            ArrayList rowList = new ArrayList();
            return new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(true).buildWithTotalRowCount(0L);
        }
        return this.repositoryCategoryOperations.loadRuleListForCategories(request);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void removeCategory(String categoryPath) throws SerializationException {
        this.repositoryCategoryOperations.removeCategory(categoryPath);
    }
}

