/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.repository.AssetItem;

public class DeclaredTypesSorter {
    private static final Pattern typeFinder = Pattern.compile("(declare\\s+((\\w+)).*?\\s+end+?)", 42);
    private static final Pattern superTypeFinder = Pattern.compile("(extends\\s+((\\w+)))", 42);

    public List<DeclaredTypeAssetInheritanceInformation> sort(List<AssetItem> assets) {
        ArrayList<DeclaredTypeAssetInheritanceInformation> sortedTypes = new ArrayList<DeclaredTypeAssetInheritanceInformation>();
        for (AssetItem assetItem : assets) {
            List<DeclaredTypeInheritanceInformation> individualTypes = this.parseIndividualTypes(assetItem.getContent());
            for (DeclaredTypeInheritanceInformation individualType : individualTypes) {
                sortedTypes.add(new DeclaredTypeAssetInheritanceInformation(assetItem, individualType.getType(), individualType.getSuperType(), individualType.getDrl()));
            }
        }
        HashMap<String, DeclaredTypeAssetInheritanceInformation> lookup = new HashMap<String, DeclaredTypeAssetInheritanceInformation>();
        for (DeclaredTypeAssetInheritanceInformation type : sortedTypes) {
            lookup.put(type.getType(), type);
        }
        for (DeclaredTypeAssetInheritanceInformation type : sortedTypes) {
            String superType = type.getSuperType();
            while (superType != null) {
                type.increaseDependencyScore();
                if (!lookup.containsKey(superType)) continue;
                superType = ((DeclaredTypeAssetInheritanceInformation)lookup.get(superType)).getSuperType();
            }
        }
        Collections.sort(sortedTypes, new Comparator<DeclaredTypeAssetInheritanceInformation>(){

            @Override
            public int compare(DeclaredTypeAssetInheritanceInformation o1, DeclaredTypeAssetInheritanceInformation o2) {
                return o1.getDependencyScore() - o2.getDependencyScore();
            }
        });
        return sortedTypes;
    }

    List<DeclaredTypeInheritanceInformation> parseIndividualTypes(String typesDrl) {
        ArrayList<DeclaredTypeInheritanceInformation> individualTypes = new ArrayList<DeclaredTypeInheritanceInformation>();
        Matcher tm = typeFinder.matcher(typesDrl);
        while (tm.find()) {
            String type = tm.group(2);
            String typeDrl = tm.group(1);
            String superType = this.getSuperType(typeDrl);
            individualTypes.add(new DeclaredTypeInheritanceInformation(type, superType, typeDrl));
        }
        return individualTypes;
    }

    private String getSuperType(String typeDrl) {
        Matcher stm = superTypeFinder.matcher(typeDrl);
        if (stm.find()) {
            return stm.group(2);
        }
        return null;
    }

    static class DeclaredTypeAssetInheritanceInformation
    extends DeclaredTypeInheritanceInformation {
        private final AssetItem owningAssetItem;

        private DeclaredTypeAssetInheritanceInformation(AssetItem owningAssetItem, String type, String superType, String drl) {
            super(type, superType, drl);
            this.owningAssetItem = owningAssetItem;
        }

        public AssetItem getOwningAssetItem() {
            return this.owningAssetItem;
        }
    }

    static class DeclaredTypeInheritanceInformation {
        private final String type;
        private final String superType;
        private final String drl;
        private int dependencyScore = 0;

        private DeclaredTypeInheritanceInformation(String type, String superType, String drl) {
            this.type = type;
            this.superType = superType;
            this.drl = drl;
        }

        public String getType() {
            return this.type;
        }

        public String getSuperType() {
            return this.superType;
        }

        public String getDrl() {
            return this.drl;
        }

        void increaseDependencyScore() {
            ++this.dependencyScore;
        }

        int getDependencyScore() {
            return this.dependencyScore;
        }
    }
}

