/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.maven.cache;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.commons.io.FileUtils;
import org.drools.guvnor.client.rpc.MavenArtifact;
import org.drools.guvnor.server.maven.ArtifactDependencySupport;
import org.drools.guvnor.server.maven.cache.FileDownloadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuvnorArtifactCacheSupport {
    public static final String CLASSPATH_MAVEN_REPOSITORIES = "org/drools/guvnor/server/maven/maven-respositories.txt";
    public static final String SYSTEM_FILE_SEPARATOR = System.getProperty("file.separator");
    private static final Logger log = LoggerFactory.getLogger(GuvnorArtifactCacheSupport.class);
    private static Collection<String> mavenRepositories = null;
    private static String guvnorTempDir = null;
    private static boolean hasAlreadyBuildLocalCache = false;

    public static Collection<File> resolveArtifacts(Collection<MavenArtifact> artifactsToBeExcluded) {
        ArrayList<MavenArtifact> dependenciesToBeResolved = new ArrayList<MavenArtifact>(ArtifactDependencySupport.getDependencyList());
        if (artifactsToBeExcluded != null) {
            dependenciesToBeResolved.removeAll(artifactsToBeExcluded);
        }
        return GuvnorArtifactCacheSupport.resolveDependencies(dependenciesToBeResolved);
    }

    public static synchronized Collection<File> resolveDependencies(Collection<MavenArtifact> dependenciesToBeResolved) {
        Preconditions.checkNotNull(dependenciesToBeResolved);
        if (!hasAlreadyBuildLocalCache) {
            GuvnorArtifactCacheSupport.buildCache(GuvnorArtifactCacheSupport.getMavenRepositoryList(), ArtifactDependencySupport.getDependencyList());
        }
        ArrayList<File> result = new ArrayList<File>(dependenciesToBeResolved.size());
        for (MavenArtifact activeArtifact : dependenciesToBeResolved) {
            File file = new File(GuvnorArtifactCacheSupport.getGuvnorTempDir() + activeArtifact.toFileName());
            if (file.exists() && file.isFile()) {
                result.add(file);
                continue;
            }
            log.error("Can't resolve following dependency: " + activeArtifact.toFileName());
        }
        return result;
    }

    public static void buildCache(Collection<String> repositories, Collection<MavenArtifact> dependencies) {
        HashSet<MavenArtifact> dependenciesToBeResolved = new HashSet<MavenArtifact>(dependencies);
        for (String activeRepository : repositories) {
            ArrayList<MavenArtifact> missingDependencies = new ArrayList<MavenArtifact>();
            for (MavenArtifact mavenArtifact : dependenciesToBeResolved) {
                File file = GuvnorArtifactCacheSupport.resolveFile(mavenArtifact.toURL(activeRepository), mavenArtifact.toFileName());
                if (file != null) continue;
                missingDependencies.add(mavenArtifact);
            }
            if (missingDependencies.size() == 0) {
                dependenciesToBeResolved.clear();
                break;
            }
            dependenciesToBeResolved = new HashSet(missingDependencies);
        }
        for (MavenArtifact artifact : dependenciesToBeResolved) {
            log.error("Can't resolve following artifact: " + artifact.toFileName());
        }
        hasAlreadyBuildLocalCache = true;
    }

    private static File resolveFile(String url, String fileName) {
        File localFile = new File(GuvnorArtifactCacheSupport.getGuvnorTempDir() + fileName);
        if (localFile.exists() && localFile.isFile()) {
            return localFile;
        }
        return FileDownloadUtil.downloadFile(url, GuvnorArtifactCacheSupport.getGuvnorTempDir() + fileName);
    }

    public static synchronized Collection<String> getMavenRepositoryList() {
        if (mavenRepositories == null) {
            mavenRepositories = new LinkedHashSet<String>();
            mavenRepositories.add(GuvnorArtifactCacheSupport.getURLtoLocalUserMavenRepo());
            BufferedReader buffer = new BufferedReader(new InputStreamReader(ArtifactDependencySupport.class.getClassLoader().getResourceAsStream(CLASSPATH_MAVEN_REPOSITORIES)));
            try {
                String strLine;
                while ((strLine = buffer.readLine()) != null) {
                    mavenRepositories.add(strLine);
                }
            }
            catch (IOException e) {
                log.error("Can't read following classpath resource: org/drools/guvnor/server/maven/maven-respositories.txt");
            }
        }
        return mavenRepositories;
    }

    public static String getURLtoLocalUserMavenRepo() {
        return "file:///" + GuvnorArtifactCacheSupport.getUserHomeDir() + SYSTEM_FILE_SEPARATOR + ".m2" + SYSTEM_FILE_SEPARATOR + "repository" + SYSTEM_FILE_SEPARATOR;
    }

    public static String getUserHomeDir() {
        String userHome = System.getProperty("user.home");
        if (!userHome.endsWith("/") && !userHome.endsWith("\\")) {
            userHome = userHome + SYSTEM_FILE_SEPARATOR;
        }
        return userHome;
    }

    public static void cleanTempDir() {
        try {
            FileUtils.deleteDirectory((File)new File(GuvnorArtifactCacheSupport.getGuvnorTempDir()));
            hasAlreadyBuildLocalCache = false;
            new File(GuvnorArtifactCacheSupport.getGuvnorTempDir()).mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getGuvnorTempDir() {
        if (guvnorTempDir == null) {
            String tempdir = System.getProperty("java.io.tmpdir");
            if (!tempdir.endsWith("/") && !tempdir.endsWith("\\")) {
                tempdir = tempdir + SYSTEM_FILE_SEPARATOR;
            }
            guvnorTempDir = tempdir + "guvnor" + SYSTEM_FILE_SEPARATOR;
            new File(guvnorTempDir).mkdirs();
        }
        return guvnorTempDir;
    }
}

