/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ITransaction;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.locking.ResourceLocks;
import net.sf.webdav.methods.AbstractMethod;
import net.sf.webdav.methods.DoCopy;
import net.sf.webdav.methods.DoDelete;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoMove
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoMove.class);
    private ResourceLocks _resourceLocks;
    private DoDelete _doDelete;
    private DoCopy _doCopy;
    private boolean _readOnly;

    public DoMove(ResourceLocks resourceLocks, DoDelete doDelete, DoCopy doCopy, boolean readOnly) {
        this._resourceLocks = resourceLocks;
        this._doDelete = doDelete;
        this._doCopy = doCopy;
        this._readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        if (!this._readOnly) {
            LOG.trace("-- " + this.getClass().getName());
            String sourcePath = this.getRelativePath(req);
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, sourcePath)) {
                errorList.put(sourcePath, 423);
                this.sendReport(req, resp, errorList);
                return;
            }
            String destinationPath = req.getHeader("Destination");
            if (destinationPath == null) {
                resp.sendError(400);
                return;
            }
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, destinationPath)) {
                errorList.put(destinationPath, 423);
                this.sendReport(req, resp, errorList);
                return;
            }
            String tempLockOwner = "doMove" + System.currentTimeMillis() + req.toString();
            if (this._resourceLocks.lock(transaction, sourcePath, tempLockOwner, false, 0, 10, true)) {
                try {
                    if (!this._doCopy.copyResource(transaction, req, resp)) return;
                    errorList = new Hashtable();
                    this._doDelete.deleteResource(transaction, sourcePath, errorList, req, resp);
                    if (errorList.isEmpty()) return;
                    this.sendReport(req, resp, errorList);
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, sourcePath, tempLockOwner);
                }
            } else {
                errorList.put(req.getHeader("Destination"), 423);
                this.sendReport(req, resp, errorList);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }
}

