/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.enums;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveCommand;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.drools.enums.DeleteButtonCell;
import org.drools.guvnor.client.asseteditor.drools.enums.EnumParser;
import org.drools.guvnor.client.asseteditor.drools.enums.EnumRow;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleContentText;

public class EnumEditor
extends DirtyableComposite
implements EditorWidget,
SaveEventListener {
    private VerticalPanel panel;
    private CellTable<EnumRow> cellTable;
    private final RuleContentText data;
    private ListDataProvider<EnumRow> dataProvider = new ListDataProvider();

    public EnumEditor(Asset a, RuleViewer v, ClientFactory clientFactory, EventBus eventBus) {
        this(a);
    }

    public EnumEditor(Asset a) {
        this(a, -1);
    }

    public EnumEditor(Asset a, int visibleLines) {
        this.data = (RuleContentText)a.getContent();
        if (this.data.content == null) {
            this.data.content = "";
        }
        this.cellTable = new CellTable();
        this.cellTable.setWidth("100%");
        this.panel = new VerticalPanel();
        CellTable cellTable = new CellTable(Integer.MAX_VALUE);
        cellTable.setWidth("100%");
        DeleteButtonCell deleteButton = new DeleteButtonCell();
        Column<EnumRow, String> deleteButtonColumn = new Column<EnumRow, String>((Cell)deleteButton){

            public String getValue(EnumRow enumRow) {
                return "";
            }
        };
        Column<EnumRow, String> factNameColumn = new Column<EnumRow, String>((Cell)new EditTextCell()){

            public String getValue(EnumRow enumRow) {
                return enumRow.getFactName();
            }
        };
        Column<EnumRow, String> fieldNameColumn = new Column<EnumRow, String>((Cell)new EditTextCell()){

            public String getValue(EnumRow enumRow) {
                return enumRow.getFieldName();
            }
        };
        Column<EnumRow, String> contextColumn = new Column<EnumRow, String>((Cell)new EditTextCell()){

            public String getValue(EnumRow enumRow) {
                return enumRow.getContext();
            }
        };
        deleteButtonColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow object, String value) {
                EnumEditor.this.dataProvider.getList().remove(index);
            }
        });
        factNameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow object, String value) {
                object.setFactName(value);
            }
        });
        fieldNameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow object, String value) {
                object.setFieldName(value);
            }
        });
        contextColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow object, String value) {
                object.setContext(value);
            }
        });
        cellTable.addColumn((Column)deleteButtonColumn);
        cellTable.addColumn((Column)factNameColumn, "Fact");
        cellTable.addColumn((Column)fieldNameColumn, "Field");
        cellTable.addColumn((Column)contextColumn, "Context");
        this.dataProvider.setList(EnumParser.parseEnums(this.data.content));
        this.dataProvider.addDataDisplay((HasData)cellTable);
        Button addButton = new Button("+", new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                EnumRow enumRow = new EnumRow();
                EnumEditor.this.dataProvider.getList().add(enumRow);
            }
        });
        this.panel.add((Widget)addButton);
        this.panel.add((Widget)cellTable);
        this.initWidget((Widget)this.panel);
    }

    public void onSave(SaveCommand saveCommand) {
        this.data.content = "";
        if (!this.dataProvider.getList().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (EnumRow enumRow : this.dataProvider.getList()) {
                if (!enumRow.isValid()) continue;
                sb.append(enumRow.toString()).append("\n");
            }
            this.data.content = sb.toString();
        }
        saveCommand.save();
    }

    public void onAfterSave() {
    }
}

