/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.ImageResourceCell;
import com.google.gwt.cell.client.SelectionCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AdvancedKBaseConfigWidget;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AdvancedKSessionConfigWidget;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfigEditor;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKBaseConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.SessionType;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.util.Preconditions;
import org.drools.guvnor.client.widgets.drools.explorer.AssetDownloadLinkUtil;
import org.drools.guvnor.client.widgets.drools.explorer.AssetResourceExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ExplorerRenderMode;
import org.drools.guvnor.client.widgets.drools.explorer.PackageDisplayMode;
import org.drools.guvnor.client.widgets.drools.explorer.ResourceElementReadyCommand;

public class KBaseConfigPanel
extends DirtyableComposite {
    private static DroolsGuvnorImageResources images = (DroolsGuvnorImageResources)GWT.create(DroolsGuvnorImageResources.class);
    private static KBaseConfigEditorBinder uiBinder = (KBaseConfigEditorBinder)GWT.create(KBaseConfigEditorBinder.class);
    public static final Map<String, ImageResource> FORMAT_IMAGES = new HashMap<String, ImageResource>(){
        {
            this.put("brl", images.ruleAsset());
            this.put("drl", images.technicalRuleAssets());
            this.put("dsl", images.dsl());
            this.put("bpmn2", images.ruleflowSmall());
            this.put("gdst", images.gdst());
            this.put("changeset", images.enumeration());
            this.put("jar", images.modelAsset());
        }
    };
    private final String assetPackageUUID;
    private final String assetPackageName;
    private final ClientFactory clientFactory;
    @UiField
    protected Button btnAssetResource;
    @UiField
    protected Button btnRemoveSelected;
    @UiField
    protected Button btnRename;
    @UiField
    protected Button btnAdvancedOptions;
    @UiField
    protected Tree resourceTree;
    @UiField(provided=true)
    final CellTable<ServiceKSessionConfig> cellTable;
    @UiField(provided=true)
    final SimplePager pager;
    private final ListDataProvider<ServiceKSessionConfig> dataProvider = new ListDataProvider();
    private final ServiceConfig config;
    private final ServiceConfigEditor.UpdateTabEvent updateTab;
    private ServiceKBaseConfig kbase;
    private final TreeItem root;
    private final Map<String, Map<String, TreeItem>> resourcesIndex = new HashMap<String, Map<String, TreeItem>>();
    private final Map<String, TreeItem> packageIndex = new HashMap<String, TreeItem>();
    public static final ProvidesKey<ServiceKSessionConfig> KEY_PROVIDER = new ProvidesKey<ServiceKSessionConfig>(){

        public Object getKey(ServiceKSessionConfig item) {
            return item == null ? null : item.getName();
        }
    };

    public KBaseConfigPanel(ServiceConfig config, ServiceKBaseConfig kbase, ServiceConfigEditor.UpdateTabEvent updateTab, String assetPackageUUID, String assetPackageName, ClientFactory clientFactory) {
        this.kbase = (ServiceKBaseConfig)Preconditions.checkNotNull((String)"kbase", (Object)kbase);
        this.config = (ServiceConfig)Preconditions.checkNotNull((String)"config", (Object)config);
        this.updateTab = (ServiceConfigEditor.UpdateTabEvent)Preconditions.checkNotNull((String)"updateTab", (Object)updateTab);
        this.clientFactory = clientFactory;
        this.assetPackageUUID = assetPackageUUID;
        this.assetPackageName = assetPackageName;
        this.cellTable = new CellTable(KEY_PROVIDER);
        this.cellTable.setWidth("100%", false);
        SimplePager.Resources pagerResources = (SimplePager.Resources)GWT.create(SimplePager.Resources.class);
        this.pager = new SimplePager(SimplePager.TextLocation.CENTER, pagerResources, false, 0, true);
        this.pager.setDisplay(this.cellTable);
        this.initTableColumns(this.cellTable);
        this.dataProvider.addDataDisplay(this.cellTable);
        this.dataProvider.getList().addAll(kbase.getKsessions());
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.root = this.resourceTree.addItem(this.treeItemFormat(kbase.getName(), images.enumeration()));
        this.loadContent();
    }

    private void initTableColumns(final CellTable<ServiceKSessionConfig> cellTable) {
        MyClickableImageCell addRowCell = new MyClickableImageCell(new MyClickableImageCell.ImageCellClickHandler(){

            @Override
            public void onClick(Cell.Context context) {
                ServiceKSessionConfig newKsession = new ServiceKSessionConfig(KBaseConfigPanel.this.kbase.getNextKSessionName());
                KBaseConfigPanel.this.kbase.addKsession(newKsession);
                KBaseConfigPanel.this.dataProvider.getList().add(newKsession);
                KBaseConfigPanel.this.dataProvider.refresh();
                KBaseConfigPanel.this.pager.lastPage();
            }
        });
        Column<ServiceKSessionConfig, ImageResource> imageColumn = new Column<ServiceKSessionConfig, ImageResource>((Cell)addRowCell){

            public ImageResource getValue(ServiceKSessionConfig object) {
                return images.itemImages().newItem();
            }
        };
        cellTable.addColumn((Column)imageColumn, SafeHtmlUtils.fromSafeConstant((String)"<br/>"));
        cellTable.setColumnWidth((Column)imageColumn, "16px");
        MyClickableImageCell removeRowCell = new MyClickableImageCell(new MyClickableImageCell.ImageCellClickHandler(){

            @Override
            public void onClick(Cell.Context context) {
                if (KBaseConfigPanel.this.dataProvider.getList().size() == 1) {
                    Window.alert((String)Constants.INSTANCE.KBaseNeedsOneKsession());
                } else {
                    KBaseConfigPanel.this.dataProvider.getList().remove(context.getIndex());
                    KBaseConfigPanel.this.kbase.removeKsession((String)context.getKey());
                    KBaseConfigPanel.this.dataProvider.refresh();
                }
            }
        });
        Column<ServiceKSessionConfig, ImageResource> imageColumn2 = new Column<ServiceKSessionConfig, ImageResource>((Cell)removeRowCell){

            public ImageResource getValue(ServiceKSessionConfig object) {
                return images.removeItem();
            }
        };
        cellTable.addColumn((Column)imageColumn2, SafeHtmlUtils.fromSafeConstant((String)"<br/>"));
        cellTable.setColumnWidth((Column)imageColumn, "16px");
        final EditTextCell textCell = new EditTextCell();
        Column<ServiceKSessionConfig, String> nameColumn = new Column<ServiceKSessionConfig, String>((Cell)textCell){

            public String getValue(ServiceKSessionConfig object) {
                return object.getName();
            }
        };
        cellTable.addColumn((Column)nameColumn, Constants.INSTANCE.Name());
        nameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<ServiceKSessionConfig, String>(){

            public void update(int index, ServiceKSessionConfig object, String value) {
                if (object.getName().equals(value)) {
                    return;
                }
                if (KBaseConfigPanel.this.kbase.getKsession(value) != null) {
                    Window.alert((String)Constants.INSTANCE.KSessionNameAlreadyExists());
                    textCell.clearViewData(KEY_PROVIDER.getKey((Object)object));
                    KBaseConfigPanel.this.dataProvider.flush();
                    KBaseConfigPanel.this.dataProvider.refresh();
                    cellTable.redraw();
                } else {
                    ServiceKSessionConfig updatedKsession = new ServiceKSessionConfig(value, object);
                    KBaseConfigPanel.this.kbase.removeKsession(object.getName());
                    KBaseConfigPanel.this.kbase.addKsession(updatedKsession);
                    KBaseConfigPanel.this.dataProvider.getList().set(index, updatedKsession);
                    KBaseConfigPanel.this.dataProvider.refresh();
                }
            }
        });
        cellTable.setColumnWidth((Column)nameColumn, "40%");
        ArrayList<String> sessionTypes = new ArrayList<String>(SessionType.values().length);
        for (SessionType activeType : SessionType.values()) {
            sessionTypes.add(activeType.toString().toLowerCase());
        }
        SelectionCell typeCell = new SelectionCell(sessionTypes);
        Column<ServiceKSessionConfig, String> typeColumn = new Column<ServiceKSessionConfig, String>((Cell)typeCell){

            public String getValue(ServiceKSessionConfig object) {
                return object.getType().toString().toLowerCase();
            }
        };
        cellTable.addColumn((Column)typeColumn, Constants.INSTANCE.Type());
        typeColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<ServiceKSessionConfig, String>(){

            public void update(int index, ServiceKSessionConfig object, String value) {
                object.setType(SessionType.valueOf(value.toUpperCase()));
                KBaseConfigPanel.this.dataProvider.refresh();
            }
        });
        cellTable.setColumnWidth((Column)typeColumn, "40%");
        Column<ServiceKSessionConfig, String> configAdvanced = new Column<ServiceKSessionConfig, String>((Cell)new ButtonCell()){

            public String getValue(ServiceKSessionConfig object) {
                return "...";
            }
        };
        cellTable.addColumn((Column)configAdvanced, Constants.INSTANCE.Config());
        configAdvanced.setFieldUpdater((FieldUpdater)new FieldUpdater<ServiceKSessionConfig, String>(){

            public void update(int index, ServiceKSessionConfig object, String value) {
                final AdvancedKSessionConfigWidget widget = new AdvancedKSessionConfigWidget(object);
                final InternalPopup popup = new InternalPopup(widget.asWidget(), Constants.INSTANCE.KSessionConfiguration());
                popup.addOkButtonClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        widget.updateKSession();
                        popup.hide();
                    }
                });
                popup.show();
            }
        });
        cellTable.setColumnWidth((Column)configAdvanced, "20%");
    }

    private void loadContent() {
        for (AssetReference assetReference : this.kbase.getResources()) {
            this.addResource(assetReference);
        }
        for (AssetReference modelReference : this.kbase.getModels()) {
            this.addResource(modelReference);
        }
    }

    @UiHandler(value={"btnRemoveSelected"})
    public void removeSelectedElements(ClickEvent e) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        this.buildExcludedList(this.root, result);
        for (TreeItem item : result) {
            if (item.getUserObject() != null) {
                this.removeFromIndexes((AssetReference)item.getUserObject());
            }
            if (item.getUserObject() == null) continue;
            item.remove();
        }
    }

    private void removeFromIndexes(AssetReference userObject) {
        this.removeFromIndex(userObject, this.packageIndex);
        for (Map<String, TreeItem> pkgItem : this.resourcesIndex.values()) {
            this.removeFromIndex(userObject, pkgItem);
        }
    }

    private void removeFromIndex(AssetReference userObject, Map<String, TreeItem> index) {
        for (Map.Entry<String, TreeItem> element : index.entrySet()) {
            AssetReference activeAsset;
            if (element.getValue().getUserObject() == null || !(activeAsset = (AssetReference)element.getValue().getUserObject()).getUuid().equals(userObject.getUuid())) continue;
            index.remove(element.getKey());
            break;
        }
    }

    private void buildExcludedList(TreeItem item, List<TreeItem> result) {
        if (item.getWidget() != null && ((CheckBox)item.getWidget()).getValue().booleanValue()) {
            result.add(item);
        }
        if (item.getChildCount() > 0) {
            for (int i = 0; i < item.getChildCount(); ++i) {
                this.buildExcludedList(item.getChild(i), result);
            }
        }
    }

    @UiHandler(value={"btnAssetResource"})
    public void addNewAssetResource(ClickEvent e) {
        final AssetResourceExplorerWidget widget = new AssetResourceExplorerWidget(this.assetPackageUUID, this.assetPackageName, this.clientFactory, AssetFormats.SERVICE_CONFIG_RESOURCE, ExplorerRenderMode.HIDE_NAME_AND_DESCRIPTION, PackageDisplayMode.ALL_PACKAGES);
        final InternalPopup popup = new InternalPopup(widget.asWidget(), Constants.INSTANCE.AddNewAsset());
        popup.addOkButtonClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    widget.processSelectedResources(new ResourceElementReadyCommand(){

                        @Override
                        public void onSuccess(String packageRef, Asset[] result, String name, String description) {
                            for (Asset asset : result) {
                                AssetReference reference = new AssetReference(packageRef, asset.getName(), asset.getFormat(), AssetDownloadLinkUtil.buildDownloadLink(asset, packageRef), asset.getUuid());
                                KBaseConfigPanel.this.addResource(reference);
                            }
                        }

                        @Override
                        public void onFailure(Throwable cause) {
                            ErrorPopup.showMessage((String)cause.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    ErrorPopup.showMessage((String)e.getMessage());
                }
                popup.hide();
            }
        });
        popup.show();
    }

    private void addResource(AssetReference asset) {
        if (!this.resourcesIndex.containsKey(asset.getPackageRef())) {
            this.packageIndex.put(asset.getPackageRef(), this.buildTreeItem(this.root, asset.getPackageRef(), images.packageImage(), null));
            this.resourcesIndex.put(asset.getPackageRef(), new HashMap());
        }
        TreeItem pkg = this.packageIndex.get(asset.getPackageRef());
        if (!this.resourcesIndex.get(asset.getPackageRef()).containsKey(asset.getFormat())) {
            TreeItem newFormat = this.buildTreeItem(pkg, asset.getFormat(), FORMAT_IMAGES.get(asset.getFormat()), null);
            this.resourcesIndex.get(asset.getPackageRef()).put(asset.getFormat(), newFormat);
        }
        TreeItem parent = this.resourcesIndex.get(asset.getPackageRef()).get(asset.getFormat());
        this.buildTreeItem(parent, asset.getName(), images.rules(), asset);
        this.makeDirty();
    }

    private TreeItem buildTreeItem(TreeItem parent, String text, ImageResource image, AssetReference asset) {
        if (asset != null) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                AssetReference currentAsset;
                if (parent.getChild(i).getUserObject() == null || !(currentAsset = (AssetReference)parent.getChild(i).getUserObject()).getName().equals(text)) continue;
                return parent.getChild(i);
            }
        }
        CheckBox checkBox = new CheckBox(this.treeItemFormat(text, image));
        final TreeItem newTreeItem = parent.addItem((Widget)checkBox);
        newTreeItem.setUserObject((Object)asset);
        checkBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CheckBox me = (CheckBox)event.getSource();
                boolean checked = me.getValue();
                if (newTreeItem.getChildCount() > 0) {
                    for (int i = 0; i < newTreeItem.getChildCount(); ++i) {
                        this.defineState(newTreeItem.getChild(i), checked);
                    }
                }
            }

            private void defineState(TreeItem currentItem, boolean checked) {
                ((CheckBox)currentItem.getWidget()).setValue(Boolean.valueOf(checked));
                if (currentItem.getChildCount() > 0) {
                    for (int i = 0; i < currentItem.getChildCount(); ++i) {
                        this.defineState(currentItem.getChild(i), checked);
                    }
                }
            }
        });
        parent.setState(true, false);
        newTreeItem.setState(true, false);
        return newTreeItem;
    }

    private SafeHtml treeItemFormat(String text, ImageResource image) {
        return new SafeHtmlBuilder().append(SafeHtmlUtils.fromTrustedString((String)AbstractImagePrototype.create((ImageResource)image).getHTML())).appendEscaped(" ").appendEscaped(text).toSafeHtml();
    }

    @UiHandler(value={"btnRename"})
    public void doRename(ClickEvent e) {
        Image image = new Image(DroolsGuvnorImageResources.INSTANCE.packageLarge());
        image.setAltText(Constants.INSTANCE.Package());
        final FormStylePopup pop = new FormStylePopup(image, Constants.INSTANCE.RenameThisKBase());
        final TextBox box = new TextBox();
        box.setText(this.kbase.getName());
        pop.addAttribute(Constants.INSTANCE.NewNameAsset(), (Widget)box);
        Button ok = new Button(Constants.INSTANCE.RenameKBase());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                String newName = box.getText().trim();
                if (KBaseConfigPanel.this.kbase.getName().equals(newName)) {
                    pop.hide();
                    return;
                }
                if (KBaseConfigPanel.this.config.getKbase(newName) != null) {
                    Window.alert((String)Constants.INSTANCE.KBaseNameAlreadyExists());
                    pop.hide();
                    return;
                }
                KBaseConfigPanel.this.config.removeKBase(KBaseConfigPanel.this.kbase.getName());
                KBaseConfigPanel.this.kbase = new ServiceKBaseConfig(newName, KBaseConfigPanel.this.kbase);
                KBaseConfigPanel.this.config.addKBase(KBaseConfigPanel.this.kbase);
                KBaseConfigPanel.this.updateTab.onUpdate(newName);
                KBaseConfigPanel.this.root.setHTML(KBaseConfigPanel.this.treeItemFormat(KBaseConfigPanel.this.kbase.getName(), images.enumeration()));
                pop.hide();
            }
        });
        pop.show();
    }

    public void onSave() {
        ArrayList<AssetReference> resources = new ArrayList<AssetReference>();
        ArrayList<AssetReference> models = new ArrayList<AssetReference>();
        Iterator iterator = this.resourceTree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            if (item.getUserObject() == null) continue;
            AssetReference assetReference = (AssetReference)item.getUserObject();
            if (assetReference.getFormat().equals("jar")) {
                models.add(assetReference);
                continue;
            }
            resources.add(assetReference);
        }
        this.kbase.setModels(models);
        this.kbase.setResources(resources);
    }

    @UiHandler(value={"btnAdvancedOptions"})
    public void advancedOptions(ClickEvent e) {
        final AdvancedKBaseConfigWidget widget = new AdvancedKBaseConfigWidget(this.kbase);
        final InternalPopup popup = new InternalPopup(widget.asWidget(), Constants.INSTANCE.KBaseAdvancedOptions());
        popup.addOkButtonClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                widget.updateKBase();
                popup.hide();
            }
        });
        popup.show();
    }

    public ServiceKBaseConfig getKBase() {
        return this.kbase;
    }

    private static class MyClickableImageCell
    extends ImageResourceCell {
        private final ImageCellClickHandler clickHandler;

        public MyClickableImageCell(ImageCellClickHandler handler) {
            this.clickHandler = (ImageCellClickHandler)Preconditions.checkNotNull((String)"handler", (Object)handler);
        }

        public Set<String> getConsumedEvents() {
            HashSet<String> consumedEvents = new HashSet<String>();
            consumedEvents.add("click");
            return consumedEvents;
        }

        public void onBrowserEvent(Cell.Context context, Element parent, ImageResource value, NativeEvent event, ValueUpdater<ImageResource> valueUpdater) {
            switch (DOM.eventGetType((Event)((Event)event))) {
                case 1: {
                    this.clickHandler.onClick(context);
                    break;
                }
            }
        }

        private static interface ImageCellClickHandler {
            public void onClick(Cell.Context var1);
        }
    }

    private class InternalPopup
    extends FormStylePopup {
        private final Button ok = new Button(Constants.INSTANCE.OK());

        public InternalPopup(Widget content, String title) {
            this.setTitle(title);
            HorizontalPanel hor = new HorizontalPanel();
            Button cancel = new Button(Constants.INSTANCE.Cancel());
            hor.add((Widget)this.ok);
            hor.add((Widget)cancel);
            this.addRow(content);
            this.addRow((Widget)hor);
            cancel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    InternalPopup.this.hide();
                }
            });
        }

        public void addOkButtonClickHandler(ClickHandler clickHandler) {
            this.ok.addClickHandler(clickHandler);
        }
    }

    static interface KBaseConfigEditorBinder
    extends UiBinder<Widget, KBaseConfigPanel> {
    }
}

