/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid;

import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractDecoratedGridSidebarWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.ResourcesProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicData;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.RowMapper;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.AppendRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.DeleteRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.InsertRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.PasteRowsEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.RowGroupingChangeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.ToggleMergingEvent;

public abstract class AbstractVerticalDecoratedGridSidebarWidget<M, T>
extends AbstractDecoratedGridSidebarWidget<M, T> {
    private ScrollPanel scrollPanel;
    private VerticalSelectorWidget selectors;
    private VerticalSideBarSpacerWidget spacer = new VerticalSideBarSpacerWidget();
    protected DynamicData data;
    protected RowMapper rowMapper;

    public AbstractVerticalDecoratedGridSidebarWidget(ResourcesProvider<T> resources, boolean isReadOnly, EventBus eventBus) {
        super(resources, isReadOnly, eventBus);
        this.scrollPanel = new ScrollPanel();
        VerticalPanel container = new VerticalPanel();
        this.selectors = new VerticalSelectorWidget(eventBus);
        container.add((Widget)this.spacer);
        container.add((Widget)this.scrollPanel);
        this.scrollPanel.add((Widget)this.selectors);
        this.scrollPanel.getElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.initWidget((Widget)container);
    }

    @Override
    void resizeSidebar(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        this.spacer.setHeight(height);
    }

    public void setHeight(String height) {
        if (height == null) {
            throw new IllegalArgumentException("height cannot be null");
        }
        this.scrollPanel.setHeight(height);
    }

    @Override
    public void setScrollPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be less than zero");
        }
        this.scrollPanel.setVerticalScrollPosition(position);
    }

    @Override
    protected void redraw() {
        this.selectors.redraw();
    }

    @Override
    public void onDeleteRow(DeleteRowEvent event) {
        int index = this.rowMapper.mapToMergedRow(event.getIndex());
        this.selectors.deleteRow(index);
    }

    @Override
    public void onInsertRow(InsertRowEvent event) {
        int index = this.rowMapper.mapToMergedRow(event.getIndex());
        this.selectors.insertRowBefore(index);
    }

    @Override
    public void onAppendRow(AppendRowEvent event) {
        this.selectors.appendRow();
    }

    @Override
    public void onPasteRows(PasteRowsEvent event) {
        int iRow = this.rowMapper.mapToMergedRow(event.getTargetRowIndex());
        this.selectors.insertRowBefore(iRow);
    }

    @Override
    public void onRowGroupingChange(RowGroupingChangeEvent event) {
        this.selectors.redraw();
    }

    private class VerticalSideBarSpacerWidget
    extends CellPanel
    implements ToggleMergingEvent.Handler {
        private Image icon = new Image();
        private Element tre = DOM.createTR();
        private Element tce = DOM.createTD();
        private Element outerDiv = DOM.createDiv();
        private Element innerDiv = DOM.createDiv();
        private boolean isMerged = false;

        public void setHeight(int height) {
            super.setHeight(height + "px");
            String innerPixelHeight = height - AbstractVerticalDecoratedGridSidebarWidget.this.resources.borderWidthThick() + "px";
            DOM.setStyleAttribute((Element)this.outerDiv, (String)"height", (String)innerPixelHeight);
        }

        private void setPadding(int padding) {
            ((TableElement)this.getBody().getParentElement().cast()).setCellPadding(0);
        }

        private VerticalSideBarSpacerWidget() {
            this.setSpacing(0);
            this.setPadding(0);
            this.setIconImage(this.isMerged);
            this.tce.addClassName(AbstractVerticalDecoratedGridSidebarWidget.this.resources.selectorSpacer());
            this.innerDiv.addClassName(AbstractVerticalDecoratedGridSidebarWidget.this.resources.selectorSpacerInnerDiv());
            this.outerDiv.addClassName(AbstractVerticalDecoratedGridSidebarWidget.this.resources.selectorSpacerOuterDiv());
            this.tre.appendChild((Node)this.tce);
            this.tce.appendChild((Node)this.outerDiv);
            this.outerDiv.appendChild((Node)this.innerDiv);
            this.innerDiv.appendChild((Node)this.icon.getElement());
            this.getBody().appendChild((Node)this.tre);
            this.innerDiv.getStyle().setHeight((double)this.icon.getHeight(), Style.Unit.PX);
            this.innerDiv.getStyle().setMarginTop((double)(this.icon.getHeight() / 2 * -1), Style.Unit.PX);
            this.innerDiv.getStyle().setWidth((double)this.icon.getWidth(), Style.Unit.PX);
            this.innerDiv.getStyle().setMarginLeft((double)(this.icon.getWidth() / 2 * -1), Style.Unit.PX);
            DOM.setEventListener((Element)this.icon.getElement(), (EventListener)new EventListener(){

                public void onBrowserEvent(Event event) {
                    if (event.getType().equals("click")) {
                        ToggleMergingEvent tme = new ToggleMergingEvent(!VerticalSideBarSpacerWidget.this.isMerged);
                        AbstractVerticalDecoratedGridSidebarWidget.this.eventBus.fireEvent((GwtEvent)tme);
                    }
                }
            });
            DOM.sinkEvents((Element)this.icon.getElement(), (int)Event.getTypeInt((String)"click"));
            AbstractVerticalDecoratedGridSidebarWidget.this.eventBus.addHandler(ToggleMergingEvent.TYPE, (EventHandler)this);
        }

        @Override
        public void onToggleMerging(ToggleMergingEvent event) {
            this.isMerged = event.isMerged();
            this.setIconImage(this.isMerged);
        }

        private void setIconImage(boolean isMerged) {
            if (isMerged) {
                this.icon.setResource(AbstractVerticalDecoratedGridSidebarWidget.this.resources.toggleUnmergeIcon());
            } else {
                this.icon.setResource(AbstractVerticalDecoratedGridSidebarWidget.this.resources.toggleMergeIcon());
            }
        }
    }

    private class VerticalSelectorWidget
    extends CellPanel {
        private ArrayList<Widget> widgets = new ArrayList();

        private VerticalSelectorWidget(EventBus eventBus) {
            ((TableElement)this.getBody().getParentElement().cast()).setCellSpacing(0);
            ((TableElement)this.getBody().getParentElement().cast()).setCellPadding(0);
            this.sinkEvents(Event.getTypeInt((String)"click"));
        }

        public void appendRow() {
            Element tre = DOM.createTR();
            Element tce = DOM.createTD();
            tre.setClassName(this.getRowStyle(this.widgets.size()));
            tce.getStyle().setHeight((double)AbstractVerticalDecoratedGridSidebarWidget.this.resources.rowHeight(), Style.Unit.PX);
            tce.addClassName(AbstractVerticalDecoratedGridSidebarWidget.this.resources.selectorCell());
            DOM.appendChild((Element)this.getBody(), (Element)tre);
            tre.appendChild((Node)tce);
            Widget widget = this.makeRowWidget();
            this.add(widget, tce);
            this.widgets.add(widget);
            this.fixStyles(this.widgets.size());
        }

        public void insertRowBefore(int index) {
            Element tre = DOM.createTR();
            Element tce = DOM.createTD();
            tre.setClassName(this.getRowStyle(this.widgets.size()));
            tce.getStyle().setHeight((double)AbstractVerticalDecoratedGridSidebarWidget.this.resources.rowHeight(), Style.Unit.PX);
            tce.addClassName(AbstractVerticalDecoratedGridSidebarWidget.this.resources.selectorCell());
            DOM.insertChild((Element)this.getBody(), (Element)tre, (int)index);
            tre.appendChild((Node)tce);
            Widget widget = this.makeRowWidget();
            this.add(widget, tce);
            this.widgets.add(index, widget);
            this.fixStyles(index);
        }

        public void deleteRow(int index) {
            Widget widget = this.widgets.get(index);
            this.remove(widget);
            ((TableSectionElement)this.getBody().cast()).deleteRow(index);
            this.widgets.remove(index);
            this.fixStyles(index);
        }

        private void redraw() {
            int iRow;
            int rowsToRemove = this.widgets.size();
            for (iRow = 0; iRow < rowsToRemove; ++iRow) {
                this.deleteRow(0);
            }
            for (iRow = 0; iRow < AbstractVerticalDecoratedGridSidebarWidget.this.data.size(); ++iRow) {
                this.appendRow();
            }
        }

        private void fixStyles(int iRow) {
            while (iRow < this.getBody().getChildCount()) {
                TableRowElement tre = (TableRowElement)this.getBody().getChild(iRow).cast();
                tre.setClassName(this.getRowStyle(iRow));
                ++iRow;
            }
        }

        private String getRowStyle(int iRow) {
            boolean isEven = iRow % 2 == 0;
            String trClasses = isEven ? AbstractVerticalDecoratedGridSidebarWidget.this.resources.cellTableEvenRow() : AbstractVerticalDecoratedGridSidebarWidget.this.resources.cellTableOddRow();
            return trClasses;
        }

        private Widget makeRowWidget() {
            SimplePanel sp;
            FocusPanel fp;
            final HorizontalPanel hp = new HorizontalPanel();
            hp.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
            hp.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
            hp.setWidth("100%");
            if (!AbstractVerticalDecoratedGridSidebarWidget.this.isReadOnly) {
                fp = new FocusPanel();
                fp.setHeight("100%");
                fp.setWidth("50%");
                fp.add((Widget)new Image(AbstractVerticalDecoratedGridSidebarWidget.this.resources.selectorAddIcon()));
                if (!AbstractVerticalDecoratedGridSidebarWidget.this.isReadOnly) {
                    fp.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            int index = AbstractVerticalDecoratedGridSidebarWidget.this.rowMapper.mapToAbsoluteRow(VerticalSelectorWidget.this.widgets.indexOf(hp));
                            InsertRowEvent ire = new InsertRowEvent(index);
                            AbstractVerticalDecoratedGridSidebarWidget.this.eventBus.fireEvent((GwtEvent)ire);
                        }
                    });
                }
                hp.add((Widget)fp);
            } else {
                sp = new SimplePanel();
                sp.setHeight("100%");
                sp.setWidth("50%");
                sp.add((Widget)new Image(AbstractVerticalDecoratedGridSidebarWidget.this.resources.selectorAddIcon()));
                hp.add((Widget)sp);
            }
            if (!AbstractVerticalDecoratedGridSidebarWidget.this.isReadOnly) {
                fp = new FocusPanel();
                fp.setHeight("100%");
                fp.setWidth("50%");
                fp.add((Widget)new Image(AbstractVerticalDecoratedGridSidebarWidget.this.resources.selectorDeleteIcon()));
                fp.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        int index = AbstractVerticalDecoratedGridSidebarWidget.this.rowMapper.mapToAbsoluteRow(VerticalSelectorWidget.this.widgets.indexOf(hp));
                        DeleteRowEvent ire = new DeleteRowEvent(index);
                        AbstractVerticalDecoratedGridSidebarWidget.this.eventBus.fireEvent((GwtEvent)ire);
                    }
                });
                hp.add((Widget)fp);
            } else {
                sp = new SimplePanel();
                sp.setHeight("100%");
                sp.setWidth("50%");
                sp.add((Widget)new Image(AbstractVerticalDecoratedGridSidebarWidget.this.resources.selectorDeleteIcon()));
                hp.add((Widget)sp);
            }
            if (!AbstractVerticalDecoratedGridSidebarWidget.this.isReadOnly) {
                hp.addDomHandler((EventHandler)new ContextMenuHandler(){

                    public void onContextMenu(ContextMenuEvent event) {
                        event.preventDefault();
                        event.stopPropagation();
                        int clientX = event.getNativeEvent().getClientX();
                        int clientY = event.getNativeEvent().getClientY();
                        AbstractVerticalDecoratedGridSidebarWidget.this.showContextMenu(VerticalSelectorWidget.this.widgets.indexOf(hp), clientX, clientY);
                    }
                }, ContextMenuEvent.getType());
            }
            return hp;
        }
    }
}

