/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseXStreamContentHandler<T extends PortableObject>
extends ContentHandler {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final XStream xt = new XStream((HierarchicalStreamDriver)new DomDriver());

    protected XStream getXStream() {
        return xt;
    }

    public void retrieveAssetContent(Asset ruleAsset, AssetItem assetItem) throws SerializationException {
        if (assetItem.getContent() != null && assetItem.getContent().length() > 0) {
            try {
                ruleAsset.setContent((PortableObject)this.getXStream().fromXML(assetItem.getContent()));
            }
            catch (RulesRepositoryException e) {
                this.log.error("error marshalling asset content: " + ruleAsset.getName(), (Throwable)e);
                throw new SerializationException(e.getMessage());
            }
        } else {
            ruleAsset.setContent((PortableObject)new WorkingSetConfigData());
        }
    }

    public void storeAssetContent(Asset ruleAsset, AssetItem assetItem) throws SerializationException {
        try {
            assetItem.updateContent(this.getXStream().toXML((Object)ruleAsset.getContent()));
        }
        catch (Exception e) {
            this.log.error("error marshalling asset content: " + ruleAsset.getName(), (Throwable)e);
            throw new SerializationException(e.getMessage());
        }
    }
}

