/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.OracleConnectionHelper;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Oracle10R1ConnectionHelper
extends OracleConnectionHelper {
    private static Logger log = LoggerFactory.getLogger(Oracle10R1ConnectionHelper.class);
    private Class<?> blobClass;
    private Integer durationSessionConstant;
    private Integer modeReadWriteConstant;

    public Oracle10R1ConnectionHelper(DataSource dataSrc, boolean block) {
        super(dataSrc, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        super.init();
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            this.blobClass = con.getClass().getClassLoader().loadClass("oracle.sql.BLOB");
            this.durationSessionConstant = new Integer(this.blobClass.getField("DURATION_SESSION").getInt(null));
            this.modeReadWriteConstant = new Integer(this.blobClass.getField("MODE_READWRITE").getInt(null));
        }
        finally {
            if (con != null) {
                DbUtility.close(con, null, null);
            }
        }
    }

    protected PreparedStatement execute(PreparedStatement stmt, Object[] params) throws SQLException {
        ArrayList<Blob> tmpBlobs = new ArrayList<Blob>();
        try {
            for (int i = 0; params != null && i < params.length; ++i) {
                Object p = params[i];
                if (p instanceof StreamWrapper) {
                    StreamWrapper wrapper = (StreamWrapper)p;
                    Blob tmp = this.createTemporaryBlob(stmt.getConnection(), wrapper.getStream());
                    tmpBlobs.add(tmp);
                    stmt.setBlob(i + 1, tmp);
                    continue;
                }
                if (p instanceof InputStream) {
                    Blob tmp = this.createTemporaryBlob(stmt.getConnection(), (InputStream)p);
                    tmpBlobs.add(tmp);
                    stmt.setBlob(i + 1, tmp);
                    continue;
                }
                stmt.setObject(i + 1, p);
            }
            stmt.execute();
            PreparedStatement i = stmt;
            return i;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            for (Blob blob : tmpBlobs) {
                try {
                    this.freeTemporaryBlob(blob);
                }
                catch (Exception e) {
                    log.warn("Could not close temporary blob", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Blob createTemporaryBlob(Connection con, InputStream in) throws Exception {
        Method createTemporary = this.blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
        Object blob = createTemporary.invoke(null, ConnectionFactory.unwrap(con), Boolean.FALSE, this.durationSessionConstant);
        Method open = this.blobClass.getMethod("open", Integer.TYPE);
        open.invoke(blob, this.modeReadWriteConstant);
        Method getBinaryOutputStream = this.blobClass.getMethod("getBinaryOutputStream", new Class[0]);
        OutputStream out = (OutputStream)getBinaryOutputStream.invoke(blob, new Object[0]);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            try {
                out.flush();
            }
            catch (IOException ioe) {}
            out.close();
        }
        Method close = this.blobClass.getMethod("close", new Class[0]);
        close.invoke(blob, new Object[0]);
        return (Blob)blob;
    }

    private void freeTemporaryBlob(Blob blob) throws Exception {
        Method freeTemporary = this.blobClass.getMethod("freeTemporary", new Class[0]);
        freeTemporary.invoke((Object)blob, new Object[0]);
    }
}

