/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.drools.repository.VersionableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ItemVersionIterator
implements Iterator {
    private static final Logger log = LoggerFactory.getLogger(ItemVersionIterator.class);
    private VersionableItem currentVersionableItem;
    private int iterationType;
    public static final int ITERATION_TYPE_SUCCESSOR = 1;
    public static final int ITERATION_TYPE_PREDECESSOR = 2;

    public ItemVersionIterator(VersionableItem versionableItem, int iterationType) {
        this.currentVersionableItem = versionableItem;
        this.iterationType = iterationType;
    }

    @Override
    public boolean hasNext() {
        if (this.currentVersionableItem == null) {
            return false;
        }
        if (this.iterationType == 1) {
            return this.currentVersionableItem.getSucceedingVersion() != null;
        }
        if (this.iterationType == 2) {
            return this.currentVersionableItem.getPrecedingVersion() != null;
        }
        log.error("Reached unexpected path of execution because iterationType is set to: " + this.iterationType);
        return false;
    }

    public Object next() {
        if (this.iterationType == 1) {
            this.currentVersionableItem = this.currentVersionableItem.getSucceedingVersion();
        } else if (this.iterationType == 2) {
            this.currentVersionableItem = this.currentVersionableItem.getPrecedingVersion();
        } else {
            log.error("Reached unexpected path of execution because iterationType is set to: " + this.iterationType);
            return null;
        }
        if (this.currentVersionableItem == null) {
            throw new NoSuchElementException();
        }
        return this.currentVersionableItem;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

