/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratorPanel;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RichTextArea;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.RdbmsConfigurable;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;

public class RepoConfigManager
extends Composite {
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private RepositoryServiceAsync service = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
    private RdbmsConfigurable rdbmsConf = new RdbmsConfigurable();
    private VerticalPanel vPanel2 = new VerticalPanel();
    private RichTextArea repoDisplayArea = new RichTextArea();
    private FlexTable layoutB = new FlexTable();
    private FlexTable layoutC = new FlexTable();
    private DecoratorPanel noJndiInfo = this.getNoJNDIDbPanel();
    private DecoratorPanel jndiInfo = this.getJNDIDbPanel();
    private FormPanel saveRepoConfigForm = new FormPanel();
    private Hidden hiddenRepoConfig = new Hidden("repoConfig");

    public RepoConfigManager() {
        PrettyFormLayout form = new PrettyFormLayout();
        form.addHeader(GuvnorImages.INSTANCE.Config(), (Widget)new HTML(this.constants.ManageRepositoryConfig()));
        DockPanel dock = new DockPanel();
        dock.setSpacing(4);
        dock.setHorizontalAlignment(DockPanel.ALIGN_CENTER);
        HorizontalPanel hPanel1 = new HorizontalPanel();
        hPanel1.add((Widget)this.getDbTypePanel());
        VerticalPanel dataInputPanel = new VerticalPanel();
        dataInputPanel.add((Widget)hPanel1);
        SimplePanel divider = new SimplePanel();
        divider.setSize("100px", "30px");
        this.vPanel2.add((Widget)divider);
        this.vPanel2.add((Widget)this.noJndiInfo);
        this.vPanel2.add((Widget)this.jndiInfo);
        this.vPanel2.setVisible(false);
        dataInputPanel.add((Widget)this.vPanel2);
        dock.add((Widget)dataInputPanel, DockPanel.WEST);
        this.repoDisplayArea.setSize("740px", "470px");
        this.repoDisplayArea.setTitle("repository.xml");
        this.repoDisplayArea.setVisible(false);
        DockPanel idock = new DockPanel();
        idock.setSpacing(4);
        idock.setHorizontalAlignment(DockPanel.ALIGN_CENTER);
        idock.add((Widget)this.repoDisplayArea, DockPanel.WEST);
        Button saveButton = new Button(this.constants.SaveRepo());
        saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                String name = RepoConfigManager.this.rdbmsConf.getDbType() + "-repository";
                if (RepoConfigManager.this.rdbmsConf.isJndi()) {
                    name = name + "-jndi";
                }
                RepoConfigManager.this.hiddenRepoConfig.setValue(RepoConfigManager.this.repoDisplayArea.getText());
                RepoConfigManager.this.saveRepoConfigForm.submit();
            }
        });
        this.saveRepoConfigForm.setEncoding("application/x-www-form-urlencoded");
        this.saveRepoConfigForm.setMethod("post");
        this.saveRepoConfigForm.setAction(GWT.getModuleBaseURL() + "backup");
        VerticalPanel formHolder = new VerticalPanel();
        HorizontalPanel saveInfoHolder = new HorizontalPanel();
        saveInfoHolder.add((Widget)saveButton);
        saveInfoHolder.add((Widget)new InfoPopup(this.constants.SaveRepo(), this.constants.SaveRepoInfo()));
        formHolder.add((Widget)saveInfoHolder);
        formHolder.add((Widget)this.hiddenRepoConfig);
        this.saveRepoConfigForm.add((Widget)formHolder);
        this.saveRepoConfigForm.setVisible(false);
        idock.add((Widget)this.saveRepoConfigForm, DockPanel.EAST);
        dock.add((Widget)idock, DockPanel.EAST);
        form.startSection(this.constants.ManageRepositoryConfigDesc());
        form.addAttribute("", (Widget)dock);
        form.endSection();
        this.initWidget((Widget)form);
    }

    public static ListBox getDatabaseList() {
        ConstantsCore cons = (ConstantsCore)GWT.create(ConstantsCore.class);
        ListBox list = new ListBox();
        list.addItem(cons.Choose());
        list.addItem("Microsoft SQL Server", "mssql");
        list.addItem("MySQL", "mysql");
        list.addItem("Oracle 9i", "oracle9i");
        list.addItem("Oracle 10g", "oracle10g");
        list.addItem("Oracle 11", "oracle11");
        list.addItem("PostgreSQL", "postgressql");
        list.addItem("Derby", "derby");
        list.addItem("H2", "h2");
        return list;
    }

    private void generateConfig() {
        String name = this.rdbmsConf.getDbType() + "-repository";
        if (this.rdbmsConf.isJndi()) {
            name = name + "-jndi";
        }
        this.service.processTemplate(name, this.rdbmsConf.getMapRep(), (AsyncCallback<String>)new GenericCallback<String>(){

            public void onSuccess(String repoc) {
                RepoConfigManager.this.showRepoSource(repoc);
            }
        });
        if (!this.repoDisplayArea.isVisible()) {
            this.repoDisplayArea.setVisible(true);
            this.saveRepoConfigForm.setVisible(true);
        }
    }

    private void showRepoSource(String src) {
        this.repoDisplayArea.setHTML("<pre>" + src + "</pre>");
    }

    public DecoratorPanel getDbTypePanel() {
        FlexTable layoutA = new FlexTable();
        layoutA.setCellSpacing(6);
        FlexTable.FlexCellFormatter cellFormatter = layoutA.getFlexCellFormatter();
        layoutA.setHTML(0, 0, "RDBMS Info");
        cellFormatter.setColSpan(0, 0, 2);
        cellFormatter.setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER);
        layoutA.setHTML(1, 0, this.constants.SelectRdbmsType());
        final ListBox databaseList = RepoConfigManager.getDatabaseList();
        databaseList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ListBox listBox = (ListBox)event.getSource();
                int index = listBox.getSelectedIndex();
                RepoConfigManager.this.rdbmsConf.setDbType(listBox.getItemText(index));
                RepoConfigManager.this.layoutB.setHTML(0, 0, listBox.getItemText(index) + " Info");
                RepoConfigManager.this.layoutC.setHTML(0, 0, listBox.getItemText(index) + " Info");
                RepoConfigManager.this.repoDisplayArea.setVisible(false);
                RepoConfigManager.this.saveRepoConfigForm.setVisible(false);
            }
        });
        if (this.rdbmsConf.getDbType() == null || this.rdbmsConf.getDbType().length() < 1) {
            databaseList.setSelectedIndex(0);
        } else {
            for (int i = 0; i < databaseList.getItemCount(); ++i) {
                if (!this.rdbmsConf.getDbType().equals(databaseList.getItemText(i))) continue;
                databaseList.setSelectedIndex(i);
                break;
            }
        }
        databaseList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RepoConfigManager.this.rdbmsConf.setDbType(databaseList.getValue(databaseList.getSelectedIndex()));
            }
        });
        layoutA.setWidget(1, 1, (Widget)databaseList);
        layoutA.setHTML(2, 0, this.constants.UseJndi());
        final CheckBox useJndi = new CheckBox();
        useJndi.setChecked(this.rdbmsConf.isJndi());
        useJndi.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                boolean checked = ((CheckBox)w.getSource()).getValue();
                RepoConfigManager.this.rdbmsConf.setJndi(checked);
                if (checked) {
                    RepoConfigManager.this.noJndiInfo.setVisible(false);
                    RepoConfigManager.this.jndiInfo.setVisible(true);
                } else {
                    RepoConfigManager.this.noJndiInfo.setVisible(true);
                    RepoConfigManager.this.jndiInfo.setVisible(false);
                }
                RepoConfigManager.this.repoDisplayArea.setVisible(false);
                RepoConfigManager.this.saveRepoConfigForm.setVisible(false);
            }
        });
        layoutA.setWidget(2, 1, (Widget)useJndi);
        Button continueButton = new Button("Continue");
        continueButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (databaseList.getSelectedIndex() == 0) {
                    Window.alert((String)RepoConfigManager.this.constants.PleaseSelectRdbmsType());
                    return;
                }
                if (!useJndi.getValue().booleanValue()) {
                    RepoConfigManager.this.jndiInfo.setVisible(false);
                }
                RepoConfigManager.this.vPanel2.setVisible(true);
            }
        });
        layoutA.setWidget(3, 1, (Widget)continueButton);
        DecoratorPanel decPanel = new DecoratorPanel();
        decPanel.setWidget((Widget)layoutA);
        return decPanel;
    }

    public DecoratorPanel getNoJNDIDbPanel() {
        this.layoutB.setCellSpacing(6);
        FlexTable.FlexCellFormatter cellFormatter = this.layoutB.getFlexCellFormatter();
        this.layoutB.setHTML(0, 0, "");
        cellFormatter.setColSpan(0, 0, 2);
        cellFormatter.setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER);
        this.layoutB.setHTML(1, 0, "Driver:");
        final TextBox driverInput = new TextBox();
        if (this.rdbmsConf.getDbDriver() != null && this.rdbmsConf.getDbDriver().trim().length() > 0) {
            driverInput.setValue((Object)this.rdbmsConf.getDbDriver());
        }
        driverInput.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                RepoConfigManager.this.repoDisplayArea.setVisible(false);
                RepoConfigManager.this.saveRepoConfigForm.setVisible(false);
            }
        });
        this.layoutB.setWidget(1, 1, (Widget)driverInput);
        this.layoutB.setHTML(2, 0, "URL:");
        final TextBox urlInput = new TextBox();
        if (this.rdbmsConf.getDbUrl() != null && this.rdbmsConf.getDbUrl().trim().length() > 0) {
            urlInput.setValue((Object)this.rdbmsConf.getDbUrl());
        }
        urlInput.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                RepoConfigManager.this.repoDisplayArea.setVisible(false);
                RepoConfigManager.this.saveRepoConfigForm.setVisible(false);
            }
        });
        this.layoutB.setWidget(2, 1, (Widget)urlInput);
        this.layoutB.setHTML(3, 0, "User:");
        final TextBox userNameInput = new TextBox();
        if (this.rdbmsConf.getDbUser() != null && this.rdbmsConf.getDbUser().trim().length() > 0) {
            userNameInput.setValue((Object)this.rdbmsConf.getDbUser());
        }
        userNameInput.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                RepoConfigManager.this.repoDisplayArea.setVisible(false);
                RepoConfigManager.this.saveRepoConfigForm.setVisible(false);
            }
        });
        this.layoutB.setWidget(3, 1, (Widget)userNameInput);
        this.layoutB.setHTML(4, 0, "Password:");
        final PasswordTextBox userPassInput = new PasswordTextBox();
        if (this.rdbmsConf.getDbPass() != null && this.rdbmsConf.getDbPass().trim().length() > 0) {
            userPassInput.setValue((Object)this.rdbmsConf.getDbPass());
        }
        userPassInput.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                RepoConfigManager.this.repoDisplayArea.setVisible(false);
                RepoConfigManager.this.saveRepoConfigForm.setVisible(false);
            }
        });
        this.layoutB.setWidget(4, 1, (Widget)userPassInput);
        Button generateButton = new Button(this.constants.GenerateRepositoryConfiguration());
        generateButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (driverInput.getValue() == null || driverInput.getValue().trim().length() < 1) {
                    Window.alert((String)RepoConfigManager.this.constants.PleaseEnterDriver());
                    return;
                }
                if (urlInput.getValue() == null || urlInput.getValue().trim().length() < 1) {
                    Window.alert((String)RepoConfigManager.this.constants.PleaseEnterUrl());
                    return;
                }
                if (userNameInput.getValue() == null || userNameInput.getValue().trim().length() < 1) {
                    Window.alert((String)RepoConfigManager.this.constants.PleaseEnterUserName());
                    return;
                }
                if (userPassInput.getValue() == null || userPassInput.getValue().trim().length() < 1) {
                    Window.alert((String)RepoConfigManager.this.constants.PleaseEnterPassword());
                    return;
                }
                RepoConfigManager.this.rdbmsConf.setDbDriver(driverInput.getValue());
                RepoConfigManager.this.rdbmsConf.setDbUrl(urlInput.getValue());
                RepoConfigManager.this.rdbmsConf.setDbUser(userNameInput.getValue());
                RepoConfigManager.this.rdbmsConf.setDbPass(userPassInput.getValue());
                RepoConfigManager.this.generateConfig();
            }
        });
        this.layoutB.setWidget(5, 1, (Widget)generateButton);
        DecoratorPanel decPanel = new DecoratorPanel();
        decPanel.setWidget((Widget)this.layoutB);
        return decPanel;
    }

    public DecoratorPanel getJNDIDbPanel() {
        this.layoutC.setCellSpacing(6);
        FlexTable.FlexCellFormatter cellFormatter = this.layoutC.getFlexCellFormatter();
        this.layoutC.setHTML(0, 0, "");
        cellFormatter.setColSpan(0, 0, 2);
        cellFormatter.setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER);
        this.layoutC.setHTML(1, 0, "JNDI Name");
        final TextBox jndiNameInput = new TextBox();
        if (this.rdbmsConf.getJndiDsName() != null && this.rdbmsConf.getJndiDsName().trim().length() > 0) {
            jndiNameInput.setValue((Object)this.rdbmsConf.getJndiDsName());
        }
        jndiNameInput.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                RepoConfigManager.this.repoDisplayArea.setVisible(false);
                RepoConfigManager.this.saveRepoConfigForm.setVisible(false);
            }
        });
        this.layoutC.setWidget(1, 1, (Widget)jndiNameInput);
        Button generateButton = new Button(this.constants.GenerateRepositoryConfiguration());
        generateButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (jndiNameInput.getValue() == null || jndiNameInput.getValue().trim().length() < 1) {
                    Window.alert((String)RepoConfigManager.this.constants.PleaseEnterJndiName());
                    return;
                }
                RepoConfigManager.this.rdbmsConf.setJndiDsName(jndiNameInput.getValue());
                RepoConfigManager.this.generateConfig();
            }
        });
        this.layoutC.setWidget(2, 1, (Widget)generateButton);
        DecoratorPanel decPanel = new DecoratorPanel();
        decPanel.setWidget((Widget)this.layoutC);
        return decPanel;
    }
}

