/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.WebDavServletBean;
import org.drools.guvnor.server.files.AuthorizationHeaderChecker;
import org.drools.guvnor.server.files.WebDAVImpl;

public class WebdavServlet
extends WebDavServletBean {
    private static final long serialVersionUID = 510L;
    @Inject
    protected AuthorizationHeaderChecker authorizationHeaderChecker;
    @Inject
    protected WebDAVImpl webDAV;

    public void init() throws ServletException {
        String lazyFolderCreationOnPutValue = this.getInitParameter("lazyFolderCreationOnPut");
        boolean lazyFolderCreationOnPut = lazyFolderCreationOnPutValue != null && lazyFolderCreationOnPutValue.equals("1");
        String dftIndexFile = this.getInitParameter("default-index-file");
        String insteadOf404 = this.getInitParameter("instead-of-404");
        int noContentLengthHeader = 0;
        super.init((IWebdavStore)this.webDAV, dftIndexFile, insteadOf404, noContentLengthHeader, lazyFolderCreationOnPut);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String auth = req.getHeader("Authorization");
        if (!this.authorizationHeaderChecker.loginByHeader(auth)) {
            resp.setHeader("WWW-Authenticate", "BASIC realm=\"users\"");
            resp.sendError(401);
        } else {
            super.service(req, resp);
        }
    }
}

