/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.MethodParameterValueEditor;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.MethodInfo;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionCallMethod;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldFunction;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;

public class ActionCallMethodWidget
extends RuleModellerWidget {
    private final ActionCallMethod model;
    private final DirtyableFlexTable layout;
    private boolean isBoundFact = false;
    private String[] fieldCompletionTexts;
    private String[] fieldCompletionValues;
    private String variableClass;
    private boolean readOnly;
    private boolean isFactTypeKnown;

    public ActionCallMethodWidget(RuleModeller mod, EventBus eventBus, ActionCallMethod set, Boolean readOnly) {
        super(mod, eventBus);
        this.model = set;
        this.layout = new DirtyableFlexTable();
        this.layout.setStyleName("model-builderInner-Background");
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        if (completions.isGlobalVariable(set.variable)) {
            List infos = completions.getMethodInfosForGlobalVariable(set.variable);
            if (infos != null) {
                this.fieldCompletionTexts = new String[infos.size()];
                this.fieldCompletionValues = new String[infos.size()];
                int i = 0;
                for (MethodInfo info : infos) {
                    this.fieldCompletionTexts[i] = info.getName();
                    this.fieldCompletionValues[i] = info.getNameWithParameters();
                    ++i;
                }
                this.variableClass = completions.getGlobalVariable(set.variable);
            } else {
                this.fieldCompletionTexts = new String[0];
                this.fieldCompletionValues = new String[0];
                readOnly = true;
            }
        } else {
            FactPattern pattern = mod.getModel().getLHSBoundFact(set.variable);
            if (pattern != null) {
                List methodList = completions.getMethodNames(pattern.getFactType());
                this.fieldCompletionTexts = new String[methodList.size()];
                this.fieldCompletionValues = new String[methodList.size()];
                int i = 0;
                Iterator i$ = methodList.iterator();
                while (i$.hasNext()) {
                    String methodName;
                    this.fieldCompletionTexts[i] = methodName = (String)i$.next();
                    this.fieldCompletionValues[i] = methodName;
                    ++i;
                }
                this.variableClass = pattern.getFactType();
                this.isBoundFact = true;
            } else {
                ActionInsertFact patternRhs = mod.getModel().getRHSBoundFact(set.variable);
                if (patternRhs != null) {
                    List methodList = completions.getMethodNames(patternRhs.factType);
                    this.fieldCompletionTexts = new String[methodList.size()];
                    this.fieldCompletionValues = new String[methodList.size()];
                    int i = 0;
                    Iterator i$ = methodList.iterator();
                    while (i$.hasNext()) {
                        String methodName;
                        this.fieldCompletionTexts[i] = methodName = (String)i$.next();
                        this.fieldCompletionValues[i] = methodName;
                        ++i;
                    }
                    this.variableClass = patternRhs.factType;
                    this.isBoundFact = true;
                } else {
                    readOnly = true;
                }
            }
        }
        this.isFactTypeKnown = completions.containsFactType(this.variableClass);
        this.readOnly = readOnly == null ? !this.isFactTypeKnown : readOnly;
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        this.layout.setWidget(0, 0, this.getSetterLabel());
        DirtyableFlexTable inner = new DirtyableFlexTable();
        for (int i = 0; i < this.model.fieldValues.length; ++i) {
            ActionFieldFunction val = this.model.getFieldValue(i);
            inner.setWidget(i, 0, this.fieldSelector(val));
            inner.setWidget(i, 1, this.valueEditor(val));
        }
        this.layout.setWidget(0, 1, (Widget)inner);
    }

    private Widget getSetterLabel() {
        HorizontalPanel horiz = new HorizontalPanel();
        if (this.model.state == 0) {
            Image edit = DroolsGuvnorImages.INSTANCE.AddFieldToFact();
            edit.setAltText(Constants.INSTANCE.AddAnotherFieldToThisSoYouCanSetItsValue());
            edit.setTitle(Constants.INSTANCE.AddAnotherFieldToThisSoYouCanSetItsValue());
            edit.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Widget w = (Widget)event.getSource();
                    ActionCallMethodWidget.this.showAddFieldPopup(w);
                }
            });
            horiz.add((Widget)new SmallLabel(HumanReadable.getActionDisplayName("call") + " [" + this.model.variable + "]"));
            if (!this.readOnly) {
                horiz.add((Widget)edit);
            }
        } else {
            horiz.add((Widget)new SmallLabel(HumanReadable.getActionDisplayName("call") + " [" + this.model.variable + "." + this.model.methodName + "]"));
        }
        return horiz;
    }

    protected void showAddFieldPopup(Widget w) {
        final SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        final FormStylePopup popup = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.ChooseAMethodToInvoke());
        final ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletionTexts.length; ++i) {
            box.addItem(this.fieldCompletionTexts[i], this.fieldCompletionValues[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute(Constants.INSTANCE.ChooseAMethodToInvoke(), (Widget)box);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ((ActionCallMethodWidget)ActionCallMethodWidget.this).model.state = 1;
                String methodName = box.getItemText(box.getSelectedIndex());
                String methodNameWithParams = box.getValue(box.getSelectedIndex());
                ((ActionCallMethodWidget)ActionCallMethodWidget.this).model.methodName = methodName;
                ArrayList fieldList = new ArrayList();
                fieldList.addAll(completions.getMethodParams(ActionCallMethodWidget.this.variableClass, methodNameWithParams));
                int i = 0;
                for (String fieldParameter : fieldList) {
                    ActionCallMethodWidget.this.model.addFieldValue((ActionFieldValue)new ActionFieldFunction(methodName, String.valueOf(i), fieldParameter));
                    ++i;
                }
                ActionCallMethodWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        popup.setPopupPosition(w.getAbsoluteLeft(), w.getAbsoluteTop());
        popup.show();
    }

    private Widget valueEditor(ActionFieldFunction val) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        String type = "";
        if (completions.isGlobalVariable(this.model.variable)) {
            type = completions.getGlobalVariable(this.model.variable);
        } else {
            type = this.getModeller().getModel().getLHSBindingType(this.model.variable);
            if (type == null) {
                type = this.getModeller().getModel().getRHSBoundFact((String)this.model.variable).factType;
            }
        }
        DropDownData enums = completions.getEnums(type, val.field, (FieldNature[])this.model.fieldValues);
        return new MethodParameterValueEditor(val, enums, this.getModeller(), val.type, new Command(){

            public void execute() {
                ActionCallMethodWidget.this.setModified(true);
            }
        });
    }

    private Widget fieldSelector(ActionFieldFunction val) {
        return new SmallLabel(val.type);
    }

    public boolean isBoundFact() {
        return this.isBoundFact;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }
}

