/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModelEditor;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataTableWidget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateModellerWidgetFactory;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.templates.TemplateModel;

public class RuleTemplateEditor
extends DirtyableComposite
implements RuleModelEditor {
    private TemplateModel model;
    private RuleModeller ruleModeller;
    private SuggestionCompletionEngine sce;
    private TemplateDataTableWidget table;
    private EventBus eventBus = new SimpleEventBus();
    private EventBus globalEventBus;

    public RuleTemplateEditor(final Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus globalEventBus) {
        this.globalEventBus = globalEventBus;
        this.model = (TemplateModel)asset.getContent();
        this.ruleModeller = new RuleModeller(asset, null, clientFactory, this.eventBus, new TemplateModellerWidgetFactory());
        String packageName = asset.getMetaData().getModuleName();
        this.sce = SuggestionCompletionCache.getInstance().getEngineFromCache(packageName);
        VerticalPanel tPanel = new VerticalPanel();
        tPanel.setWidth("100%");
        tPanel.add((Widget)new Button(Constants.INSTANCE.LoadTemplateData(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                int height = (int)((double)Window.getClientHeight() * 0.7);
                int width = (int)((double)Window.getClientWidth() * 0.7);
                final FormStylePopup popUp = new FormStylePopup(Constants.INSTANCE.TemplateData(), Integer.valueOf(width));
                RuleTemplateEditor.this.table = new TemplateDataTableWidget(RuleTemplateEditor.this.model, RuleTemplateEditor.this.sce, asset.isReadonly(), RuleTemplateEditor.this.eventBus);
                RuleTemplateEditor.this.table.setPixelSize(width, height);
                popUp.addAttribute("", (Widget)RuleTemplateEditor.this.table);
                Button btnOK = new Button(ConstantsCore.INSTANCE.OK(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        popUp.hide();
                    }
                });
                Button btnAddRow = new Button(Constants.INSTANCE.AddRow(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        RuleTemplateEditor.this.table.appendRow();
                    }
                });
                HorizontalPanel pnlClose = new HorizontalPanel();
                pnlClose.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                pnlClose.add((Widget)btnOK);
                pnlClose.add((Widget)btnAddRow);
                popUp.addAttribute("", (Widget)pnlClose);
                popUp.show();
            }
        }));
        tPanel.add((Widget)this.ruleModeller);
        this.initWidget((Widget)tPanel);
    }

    @Override
    public RuleModeller getRuleModeller() {
        return this.ruleModeller;
    }
}

