/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import com.google.gwt.user.client.Command;
import org.drools.guvnor.client.explorer.navigation.qa.BulkRunResultView;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.drools.guvnor.client.util.PercentageCalculator;

public class BulkRunResultPresenter
implements BulkRunResultView.Presenter {
    private BulkTestRunResult result;
    private Command closeCommand;
    private BulkRunResultView view;
    private int totalAmountOfExpectations = 0;
    private int totalAmountOfFailedExpectations = 0;

    public BulkRunResultPresenter(BulkRunResultView view) {
        this.view = view;
        view.setPresenter(this);
    }

    private void bind() {
        if (this.resultHasErrors()) {
            this.showErrors();
        } else {
            this.showResult();
        }
    }

    private void showErrors() {
        this.view.showErrors(this.result.getResult());
    }

    private void showResult() {
        this.showSummaries();
        this.showFailuresOutOfExpectations();
        this.showResultPercent();
        this.showRulesCoveredPercent();
        this.showOverAllStatus();
        this.showUncoveredRules();
    }

    private void showRulesCoveredPercent() {
        this.view.setRulesCoveredPercent(this.result.getPercentCovered());
    }

    private void showResultPercent() {
        this.view.setResultsPercent(this.calculatePercentage());
    }

    private int calculatePercentage() {
        return (int)((float)(this.totalAmountOfExpectations - this.totalAmountOfFailedExpectations) / (float)this.totalAmountOfExpectations * 100.0f);
    }

    private void showFailuresOutOfExpectations() {
        this.view.setFailuresOutOfExpectation(this.totalAmountOfFailedExpectations, this.totalAmountOfExpectations);
    }

    private void countTestsAndFailures() {
        ScenarioResultSummary[] scenarioResultSummaries = this.result.getResults();
        if (scenarioResultSummaries != null) {
            for (ScenarioResultSummary scenarioResultSummary : scenarioResultSummaries) {
                this.totalAmountOfExpectations += scenarioResultSummary.getTotal();
                this.totalAmountOfFailedExpectations += scenarioResultSummary.getFailures();
            }
        }
    }

    private void showSummaries() {
        ScenarioResultSummary[] scenarioResultSummaries = this.result.getResults();
        if (scenarioResultSummaries != null) {
            for (ScenarioResultSummary scenarioResultSummary : scenarioResultSummaries) {
                if (scenarioResultSummary.getTotal() == 0) {
                    this.view.addMissingExpectationSummaryTableRow(scenarioResultSummary.getScenarioName(), scenarioResultSummary.getUuid());
                    continue;
                }
                this.view.addNormalSummaryTableRow(scenarioResultSummary.getFailures(), scenarioResultSummary.getTotal(), scenarioResultSummary.getScenarioName(), PercentageCalculator.calculatePercent((int)scenarioResultSummary.getFailures(), (int)scenarioResultSummary.getTotal()), scenarioResultSummary.getUuid());
            }
        }
    }

    private void showOverAllStatus() {
        if (this.hasFailures()) {
            this.view.setFailed();
        } else {
            this.view.setSuccess();
        }
    }

    private boolean hasFailures() {
        return this.totalAmountOfFailedExpectations > 0;
    }

    private void showUncoveredRules() {
        String[] rulesNotCovered = this.result.getRulesNotCovered();
        if (rulesNotCovered != null) {
            for (String ruleName : rulesNotCovered) {
                this.view.addUncoveredRules(ruleName);
            }
        }
    }

    private boolean resultHasErrors() {
        if (this.result != null && this.result.getResult() != null) {
            return this.result.getResult().hasLines();
        }
        return false;
    }

    @Override
    public void onClose() {
        this.closeCommand.execute();
    }

    public void setCloseCommand(Command closeCommand) {
        this.closeCommand = closeCommand;
    }

    public void setBulkTestRunResult(BulkTestRunResult bulkTestRunResult) {
        this.result = bulkTestRunResult;
        this.countTestsAndFailures();
        this.bind();
    }
}

