/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.export;

import java.util.Arrays;
import java.util.Calendar;
import org.assertj.core.api.Assertions;
import org.drools.guvnor.client.rpc.Module;
import org.drools.repository.AssetItem;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.ExportContext;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.PlainTextAssetWithPackagePropertyExporter;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.PlainTextAsset;
import org.junit.Test;
import org.mockito.Mockito;

public class PlainTextAssetWithPackagePropertyExporterTest {
    private PlainTextAssetWithPackagePropertyExporter exporter = new PlainTextAssetWithPackagePropertyExporter();

    @Test
    public void testExportSingleStandaloneRule() {
        String technicalRule = "dialect \"mvel\"\nagenda-group \"RULE GROUP myGroup\"\nwhen\n    list : ArrayList( )\nthen\n    list.add(1)\n    drools.setFocus(\"some-rule-group\");";
        for (String assetType : Arrays.asList("drl", "dslr")) {
            AssetItem assetItem = this.createAssetItemMock(technicalRule, assetType);
            Module jcrModule = (Module)Mockito.mock(Module.class);
            ExportContext exportContext = (ExportContext)Mockito.mock(ExportContext.class);
            Mockito.when((Object)exportContext.getJcrAssetItem()).thenReturn((Object)assetItem);
            Mockito.when((Object)exportContext.getJcrModule()).thenReturn((Object)jcrModule);
            PlainTextAsset asset = this.exporter.export(exportContext);
            String expectedContentAfterMigration = "rule \"dummy-technical-rule\"\n\ndialect \"mvel\"\nagenda-group \"RULE GROUP myGroup\"\nwhen\n    list : ArrayList( )\nthen\n    list.add(1)\n    drools.setFocus(\"some-rule-group\");\n\nend";
            Assertions.assertThat((String)asset.getContent()).isEqualTo((Object)expectedContentAfterMigration);
        }
    }

    @Test
    public void testExportWholeRuleFile() {
        String technicalRule = "package org.rules\n\nrule \"rule1\"\ndialect \"mvel\"\nagenda-group \"RULE GROUP myGroup\"\nwhen\n    list : ArrayList( )\nthen\n    list.add(1)\n    drools.setFocus(\"some-rule-group\");";
        for (String assetType : Arrays.asList("drl", "dslr")) {
            AssetItem assetItem = this.createAssetItemMock(technicalRule, assetType);
            ExportContext exportContext = (ExportContext)Mockito.mock(ExportContext.class);
            Mockito.when((Object)exportContext.getJcrAssetItem()).thenReturn((Object)assetItem);
            PlainTextAsset asset = this.exporter.export(exportContext);
            String expectedContentAfterMigration = technicalRule + "\n";
            Assertions.assertThat((String)asset.getContent()).isEqualTo((Object)expectedContentAfterMigration);
        }
    }

    private AssetItem createAssetItemMock(String content, String type) {
        AssetItem assetItem = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)assetItem.getContent()).thenReturn((Object)content);
        Mockito.when((Object)assetItem.getFormat()).thenReturn((Object)type);
        Mockito.when((Object)assetItem.getName()).thenReturn((Object)"dummy-technical-rule");
        Mockito.when((Object)assetItem.getLastContributor()).thenReturn((Object)"admin");
        Mockito.when((Object)assetItem.getCheckinComment()).thenReturn((Object)"comment");
        Mockito.when((Object)assetItem.getLastModified()).thenReturn((Object)Calendar.getInstance());
        return assetItem;
    }
}

