/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.export;

import java.io.File;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.drools.workbench.jcr2vfsmigration.JcrExporterLauncher;
import org.junit.Before;
import org.junit.Test;

public class MortgagesRepoExportTest {
    private static final File TMP_DIR = new File("target/jcr2vfs-tests");
    private static final String JCR_REPO_ZIP_NAME = "/mortgages-jcr-repo.zip";
    private File jcrRepoDir;
    private File jcrExportDir;

    @Before
    public void setup() {
        FileUtils.deleteQuietly((File)TMP_DIR);
        this.jcrRepoDir = new File(TMP_DIR, "jcr-input-repo");
        this.jcrExportDir = new File(TMP_DIR, "jcr-export-xml");
        this.jcrRepoDir.mkdirs();
        File jcrRepoZip = new File(Class.class.getResource(JCR_REPO_ZIP_NAME).getFile());
        MortgagesRepoExportTest.unzipFile(jcrRepoZip, this.jcrRepoDir);
    }

    @Test
    public void testExportMortgagesRepo() {
        String[] params = new String[]{"-i", this.jcrRepoDir.getAbsolutePath(), "-o", this.jcrExportDir.getAbsolutePath()};
        JcrExporterLauncher jcrExporterLauncher = new JcrExporterLauncher();
        jcrExporterLauncher.run(params);
    }

    private static void unzipFile(File zipFile, File outputDir) {
        try {
            new ZipFile(zipFile).extractAll(outputDir.getAbsolutePath());
        }
        catch (ZipException e) {
            throw new RuntimeException("Can't unzip file '" + zipFile.getAbsolutePath() + "' into dir '" + outputDir.getAbsolutePath() + "'!", e);
        }
    }
}

