/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.GuvnorEditor;
import org.drools.guvnor.client.asseteditor.RefreshAssetEditorEvent;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.RuleViewerSettings;
import org.drools.guvnor.client.asseteditor.ShowMessageEvent;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.moduleeditor.ArtifactEditor;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.widgets.MessageWidget;

public class RuleViewerWrapper
extends GuvnorEditor
implements RefreshAssetEditorEvent.Handler,
ShowMessageEvent.Handler {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private Asset asset;
    private boolean isHistoricalReadOnly = false;
    private RuleViewerSettings ruleViewerSettings = null;
    private final MessageWidget messageWidget = new MessageWidget();
    VerticalPanel layout = new VerticalPanel();
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public RuleViewerWrapper(ClientFactory clientFactory, EventBus eventBus, Asset asset) {
        this(clientFactory, eventBus, asset, false);
    }

    public RuleViewerWrapper(ClientFactory clientFactory, EventBus eventBus, Asset asset, boolean isHistoricalReadOnly) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.asset = asset;
        this.isHistoricalReadOnly = isHistoricalReadOnly;
        eventBus.addHandler(RefreshAssetEditorEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(ShowMessageEvent.TYPE, (EventHandler)this);
        this.initWidget((Widget)this.layout);
        this.setWidth("100%");
        this.render();
    }

    private void render() {
        ArtifactEditor artifactEditor = new ArtifactEditor(this.asset, this.clientFactory, this.eventBus, this.isHistoricalReadOnly);
        RuleViewer ruleViewer = new RuleViewer(this.asset, this.clientFactory, this.eventBus, this.ruleViewerSettings);
        boolean readOnly = this.isHistoricalReadOnly || this.asset.isReadonly() || this.asset.isArchived() || this.ruleViewerSettings != null && this.ruleViewerSettings.isStandalone();
        Widget actionToolBar = this.clientFactory.getPerspectiveFactory().getAssetEditorActionToolbar("author", this.asset, ruleViewer.getAssetEditor(), this.clientFactory, this.eventBus, readOnly);
        this.layout.clear();
        this.layout.add(actionToolBar);
        this.layout.add((Widget)this.messageWidget);
        TabPanel tabPanel = new TabPanel();
        tabPanel.setWidth("100%");
        ScrollPanel scrollPanel = new ScrollPanel();
        scrollPanel.add((Widget)artifactEditor);
        tabPanel.add((Widget)scrollPanel, this.constants.Attributes());
        scrollPanel = new ScrollPanel();
        scrollPanel.add((Widget)ruleViewer);
        tabPanel.add((Widget)scrollPanel, this.constants.Edit());
        tabPanel.selectTab(1);
        this.layout.add((Widget)tabPanel);
    }

    @Override
    public void onRefreshAsset(RefreshAssetEditorEvent refreshAssetEditorEvent) {
        if (refreshAssetEditorEvent.getAssetUUID() == null && this.asset.getMetaData().getModuleName().equals(refreshAssetEditorEvent.getModuleName()) || this.asset.getUuid().equals(refreshAssetEditorEvent.getAssetUUID())) {
            LoadingPopup.showMessage(this.constants.RefreshingItem());
            AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
            assetService.loadRuleAsset(this.asset.getUuid(), (AsyncCallback<Asset>)new GenericCallback<Asset>(){

                public void onSuccess(Asset a) {
                    RuleViewerWrapper.this.asset = a;
                    RuleViewerWrapper.this.render();
                    LoadingPopup.close();
                }
            });
        }
    }

    @Override
    public void onShowMessage(ShowMessageEvent event) {
        this.messageWidget.showMessage(event.getMessage(), event.getMessageType());
    }
}

