/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.ruleflow;

import java.util.ArrayList;
import org.drools.guvnor.client.asseteditor.ruleflow.ActionNode;
import org.drools.guvnor.client.asseteditor.ruleflow.CompositeNode;
import org.drools.guvnor.client.asseteditor.ruleflow.ElementContainerNode;
import org.drools.guvnor.client.asseteditor.ruleflow.ElementContainerTransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.EmailNode;
import org.drools.guvnor.client.asseteditor.ruleflow.EndNode;
import org.drools.guvnor.client.asseteditor.ruleflow.EventNode;
import org.drools.guvnor.client.asseteditor.ruleflow.FaultNode;
import org.drools.guvnor.client.asseteditor.ruleflow.ForEachNode;
import org.drools.guvnor.client.asseteditor.ruleflow.HumanTaskNode;
import org.drools.guvnor.client.asseteditor.ruleflow.HumanTaskTransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.JoinNode;
import org.drools.guvnor.client.asseteditor.ruleflow.LogNode;
import org.drools.guvnor.client.asseteditor.ruleflow.MileStoneNode;
import org.drools.guvnor.client.asseteditor.ruleflow.RuleFlowBaseNode;
import org.drools.guvnor.client.asseteditor.ruleflow.RuleSetNode;
import org.drools.guvnor.client.asseteditor.ruleflow.SplitNode;
import org.drools.guvnor.client.asseteditor.ruleflow.SplitTransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.StartNode;
import org.drools.guvnor.client.asseteditor.ruleflow.SubProcessNode;
import org.drools.guvnor.client.asseteditor.ruleflow.TimerNode;
import org.drools.guvnor.client.asseteditor.ruleflow.TransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.WorkItemNode;
import org.drools.guvnor.client.asseteditor.ruleflow.WorkItemTransferNode;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;

public class TransferRuleFlowNodeFactory {
    public static TransferNode createNode(RuleFlowBaseNode node) {
        TransferNode tn;
        if (node instanceof StartNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.START);
        } else if (node instanceof HumanTaskNode) {
            tn = TransferRuleFlowNodeFactory.createHumanTask((HumanTaskNode)node);
        } else if (node instanceof JoinNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.JOIN);
        } else if (node instanceof SubProcessNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.SUB_PROCESS);
        } else if (node instanceof MileStoneNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.MILESTONE);
        } else if (node instanceof TimerNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.TIMER);
        } else if (node instanceof ActionNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.ACTION_NODE);
        } else if (node instanceof WorkItemNode) {
            tn = TransferRuleFlowNodeFactory.createWorkItemNode((WorkItemNode)node);
        } else if (node instanceof RuleSetNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.RULESET);
        } else if (node instanceof SplitNode) {
            tn = TransferRuleFlowNodeFactory.createSplit((SplitNode)node);
        } else if (node instanceof ForEachNode) {
            tn = TransferRuleFlowNodeFactory.ElementContainerTransferNode((ForEachNode)node);
            tn.setType(TransferNode.Type.FOR_EACH);
        } else if (node instanceof FaultNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.FAULT);
        } else if (node instanceof EventNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.EVENT);
        } else if (node instanceof CompositeNode) {
            tn = TransferRuleFlowNodeFactory.ElementContainerTransferNode((CompositeNode)node);
            tn.setType(TransferNode.Type.COMPOSITE);
        } else if (node instanceof EndNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.END);
        } else {
            throw new IllegalArgumentException("Unkown node type " + (Object)((Object)node));
        }
        tn.setId(node.getId());
        return tn;
    }

    private static TransferNode ElementContainerTransferNode(ElementContainerNode node) {
        ElementContainerTransferNode fetn = new ElementContainerTransferNode();
        ArrayList<TransferNode> baseNodes = new ArrayList<TransferNode>();
        for (RuleFlowBaseNode subNode : node.getNodes().values()) {
            baseNodes.add(TransferRuleFlowNodeFactory.createNode(subNode));
        }
        RuleFlowContentModel model = new RuleFlowContentModel();
        model.setNodes(baseNodes);
        fetn.setContentModel(model);
        return fetn;
    }

    private static WorkItemTransferNode createWorkItemNode(WorkItemNode node) {
        WorkItemTransferNode tn = null;
        if (node instanceof EmailNode) {
            tn = new WorkItemTransferNode();
            tn.setWorkName("Email");
        } else if (node instanceof LogNode) {
            tn = new WorkItemTransferNode();
            tn.setWorkName("Log");
        }
        tn.setParameters(node.attributes);
        return tn;
    }

    private static SplitTransferNode createSplit(SplitNode node) {
        SplitTransferNode splitNode = new SplitTransferNode();
        splitNode.setSplitType(node.type);
        splitNode.setConstraints(node.constraints);
        return splitNode;
    }

    private static TransferNode createHumanTask(HumanTaskNode node) {
        HumanTaskTransferNode n = new HumanTaskTransferNode();
        n.setParameters(node.getParameters());
        return n;
    }
}

