/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;

public class StatusChangePopup
extends FormStylePopup {
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private boolean isPackage;
    private String uuid;
    private String newStatus;
    private Command changedStatus;

    public StatusChangePopup(String uuid, boolean isPackage) {
        this.uuid = uuid;
        this.isPackage = isPackage;
        super.addRow((Widget)new HTML(AbstractImagePrototype.create((ImageResource)images.statusSmall()).getHTML() + "<b>" + this.constants.ChangeStatus() + "</b>"));
        HorizontalPanel horiz = new HorizontalPanel();
        final ListBox box = new ListBox();
        LoadingPopup.showMessage(this.constants.PleaseWaitDotDotDot());
        RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
        repositoryService.listStates((AsyncCallback<String[]>)new GenericCallback<String[]>(){

            public void onSuccess(String[] list) {
                box.addItem(StatusChangePopup.this.constants.ChooseOne());
                for (String aList : list) {
                    box.addItem(aList);
                }
                LoadingPopup.close();
            }
        });
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                StatusChangePopup.this.newStatus = box.getItemText(box.getSelectedIndex());
            }
        });
        horiz.add((Widget)box);
        Button ok = new Button(this.constants.ChangeStatus());
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String newState = box.getItemText(box.getSelectedIndex());
                StatusChangePopup.this.changeState(newState);
                StatusChangePopup.this.hide();
            }
        });
        horiz.add((Widget)ok);
        Button close = new Button(this.constants.Cancel());
        close.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StatusChangePopup.this.hide();
            }
        });
        horiz.add((Widget)close);
        this.addRow((Widget)horiz);
    }

    private void changeState(String newState) {
        LoadingPopup.showMessage(this.constants.UpdatingStatus());
        AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
        if (this.isPackage) {
            assetService.changePackageState(this.uuid, this.newStatus, this.createGenericCallbackForChaneState());
        } else {
            assetService.changeState(this.uuid, this.newStatus, this.createGenericCallbackForChaneState());
        }
    }

    private GenericCallback<Void> createGenericCallbackForChaneState() {
        return new GenericCallback<Void>(){

            public void onSuccess(Void v) {
                StatusChangePopup.this.changedStatus.execute();
                LoadingPopup.close();
            }
        };
    }

    public String getState() {
        return this.newStatus;
    }

    public void setChangeStatusEvent(Command command) {
        this.changedStatus = command;
    }
}

