/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.explorer.navigation.admin.widget.StatusEditor;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;

public class StateManager
extends Composite {
    private RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private ListBox currentStatuses;

    public StateManager() {
        PrettyFormLayout form = new PrettyFormLayout();
        form.addHeader(GuvnorImages.INSTANCE.Status(), (Widget)new HTML("<b>" + this.constants.ManageStatuses() + "</b>"));
        form.startSection(this.constants.StatusTagsAreForTheLifecycleOfAnAsset());
        this.currentStatuses = new ListBox();
        this.currentStatuses.setVisibleItemCount(7);
        this.currentStatuses.setWidth("50%");
        this.refreshList();
        form.addAttribute(this.constants.CurrentStatuses(), (Widget)this.currentStatuses);
        HorizontalPanel hPanel = new HorizontalPanel();
        Button create = new Button(this.constants.NewStatus());
        create.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                StatusEditor newCat = new StatusEditor(new Command(){

                    public void execute() {
                        StateManager.this.refreshList();
                    }
                });
                newCat.show();
            }
        });
        Button edit = new Button(this.constants.RenameSelected());
        edit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (!StateManager.this.currentStatuses.isItemSelected(StateManager.this.currentStatuses.getSelectedIndex())) {
                    Window.alert((String)StateManager.this.constants.PleaseSelectAStatusToRename());
                    return;
                }
                StateManager.this.renameSelected();
            }
        });
        Button remove = new Button(this.constants.DeleteSelected());
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (!StateManager.this.currentStatuses.isItemSelected(StateManager.this.currentStatuses.getSelectedIndex())) {
                    Window.alert((String)StateManager.this.constants.PleaseSelectAStatusToRemove());
                    return;
                }
                StateManager.this.removeStatus();
            }
        });
        hPanel.add((Widget)create);
        hPanel.add((Widget)edit);
        hPanel.add((Widget)remove);
        form.addAttribute("", (Widget)hPanel);
        form.endSection();
        this.initWidget((Widget)form);
    }

    private void removeStatus() {
        String name = this.currentStatuses.getItemText(this.currentStatuses.getSelectedIndex());
        this.repositoryService.removeState(name, new GenericCallback<Void>(){

            public void onSuccess(Void v) {
                Window.alert((String)StateManager.this.constants.StatusRemoved());
                StateManager.this.refreshList();
            }
        });
    }

    private void renameSelected() {
        String newName = Window.prompt((String)this.constants.PleaseEnterTheNameYouWouldLikeToChangeThisStatusTo(), (String)"");
        String oldName = this.currentStatuses.getItemText(this.currentStatuses.getSelectedIndex());
        if (newName != null) {
            this.repositoryService.renameState(oldName, newName, new GenericCallback<Void>(){

                public void onSuccess(Void data) {
                    Window.alert((String)StateManager.this.constants.StatusRenamed());
                    StateManager.this.refreshList();
                }
            });
        }
    }

    private void refreshList() {
        LoadingPopup.showMessage(this.constants.LoadingStatuses());
        this.repositoryService.listStates((AsyncCallback<String[]>)new GenericCallback<String[]>(){

            public void onSuccess(String[] statii) {
                StateManager.this.currentStatuses.clear();
                for (String aStatii : statii) {
                    StateManager.this.currentStatuses.addItem(aStatii);
                }
                LoadingPopup.close();
            }
        });
    }
}

