/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.ModuleEditorPlace;
import org.drools.guvnor.client.moduleeditor.AssetViewerActivityView;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.util.Activity;

public class AssetViewerActivity
extends Activity
implements AssetViewerActivityView.Presenter {
    private final ClientFactory clientFactory;
    private Module packageConfigData;
    private AssetViewerActivityView view;
    private String uuid;

    public AssetViewerActivity(String uuid, ClientFactory clientFactory) {
        this.uuid = uuid;
        this.clientFactory = clientFactory;
        this.view = clientFactory.getNavigationViewFactory().getAssetViewerActivityView();
    }

    @Override
    public void start(AcceptItem acceptTabItem, EventBus eventBus) {
        this.view.showLoadingPackageInformationMessage();
        acceptTabItem.add(null, this.view);
        this.clientFactory.getModuleService().loadModule(this.uuid, (AsyncCallback<Module>)new GenericCallback<Module>(){

            public void onSuccess(Module conf) {
                AssetViewerActivity.this.packageConfigData = conf;
                RulePackageSelector.currentlySelectedPackage = AssetViewerActivity.this.packageConfigData.getName();
                AssetViewerActivity.this.fillModuleItemStructure();
                AssetViewerActivity.this.view.closeLoadingPackageInformationMessage();
            }
        });
    }

    public void viewPackageDetail(Module packageConfigData) {
        this.clientFactory.getPlaceController().goTo((Place)new ModuleEditorPlace(packageConfigData.getUuid()));
    }

    private void fillModuleItemStructure() {
        String[] registeredFormats = this.clientFactory.getPerspectiveFactory().getRegisteredAssetEditorFormats(this.packageConfigData.getFormat());
        ArrayList<FormatList> formatListGroupedByTitles = new ArrayList<FormatList>();
        for (String format : registeredFormats) {
            boolean found = false;
            for (FormatList formatListWithSameTitle : formatListGroupedByTitles) {
                found = formatListWithSameTitle.titleAlreadyExists(format);
                if (!found) continue;
                formatListWithSameTitle.add(format);
                break;
            }
            if (found) continue;
            FormatList formatListWithSameTile = new FormatList();
            formatListWithSameTile.add(format);
            formatListGroupedByTitles.add(formatListWithSameTile);
        }
        this.addTitleItems(formatListGroupedByTitles);
    }

    private void addTitleItems(List<FormatList> formatListGroupedByTitles) {
        final AssetGroupSemaphore s = new AssetGroupSemaphore(formatListGroupedByTitles.size());
        final AssetViewerSection[] sections = new AssetViewerSection[formatListGroupedByTitles.size()];
        for (int i = 0; i < formatListGroupedByTitles.size(); ++i) {
            final FormatList formatList = formatListGroupedByTitles.get(i);
            final int sectionIndex = i;
            if (formatList.size() == 0) continue;
            final List<String> formatsInList = this.getFormatsInList(formatList);
            final Boolean formatIsRegistered = this.getFormatIsRegistered(formatList);
            AssetPageRequest request = new AssetPageRequest(this.packageConfigData.getUuid(), formatsInList, formatIsRegistered);
            this.clientFactory.getAssetService().getAssetCount(request, (AsyncCallback<Long>)new GenericCallback<Long>(){

                public void onSuccess(Long count) {
                    s.recordProcessedGroup();
                    if (count > 0L) {
                        AssetViewerSection section;
                        String title = AssetViewerActivity.this.getGroupTitle(formatList.getFirst());
                        Image icon = AssetViewerActivity.this.getGroupIcon(formatList.getFirst());
                        sections[sectionIndex] = section = new AssetViewerSection(title, icon, formatsInList, formatIsRegistered);
                    } else {
                        s.recordEmptyGroup();
                        if (s.areAllGroupsEmpty()) {
                            AssetViewerActivity.this.view.showHasNoAssetsWarning(true);
                        }
                    }
                    if (s.areAllGroupsProcessed()) {
                        for (AssetViewerSection section : sections) {
                            if (section == null) continue;
                            AssetViewerActivity.this.view.addAssetFormat(section.formatsInList, section.formatIsRegistered, section.title, section.icon, AssetViewerActivity.this.packageConfigData, AssetViewerActivity.this.clientFactory);
                        }
                    }
                }
            });
        }
    }

    private List<String> getFormatsInList(FormatList formatList) {
        List<String> formatsInList = null;
        if (formatList.getFormats() != null && formatList.getFormats().length > 0) {
            formatsInList = Arrays.asList(formatList.getFormats());
        }
        return formatsInList;
    }

    private Boolean getFormatIsRegistered(FormatList formatList) {
        Boolean formatIsRegistered = null;
        if (formatList.getFormats() == null || formatList.getFormats().length == 0) {
            formatIsRegistered = false;
        }
        return formatIsRegistered;
    }

    private String getGroupTitle(String format) {
        return this.clientFactory.getAssetEditorFactory().getAssetEditorTitle(format);
    }

    private Image getGroupIcon(String format) {
        return this.clientFactory.getAssetEditorFactory().getAssetEditorIcon(format);
    }

    class FormatList {
        private List<String> formatList = new ArrayList<String>();

        FormatList() {
        }

        private boolean titleAlreadyExists(String format) {
            for (String addedFormat : this.formatList) {
                if (!this.hasSameTitle(format, addedFormat)) continue;
                return true;
            }
            return false;
        }

        private boolean hasSameTitle(String format, String addedFormat) {
            return AssetViewerActivity.this.getGroupTitle(addedFormat).equals(AssetViewerActivity.this.getGroupTitle(format));
        }

        String[] getFormats() {
            if (this.formatList.size() == 1 && "".equals(this.formatList.get(0))) {
                return new String[0];
            }
            return this.formatList.toArray(new String[this.formatList.size()]);
        }

        public void add(String format) {
            this.formatList.add(format);
        }

        public int size() {
            return this.formatList.size();
        }

        public String[] toArray(String[] strings) {
            return this.formatList.toArray(strings);
        }

        public String getFirst() {
            return this.formatList.get(0);
        }
    }

    private static class AssetViewerSection {
        String title;
        Image icon;
        List<String> formatsInList;
        Boolean formatIsRegistered;

        AssetViewerSection(String title, Image icon, List<String> formatsInList, Boolean formatIsRegistered) {
            this.title = title;
            this.icon = icon;
            this.formatsInList = formatsInList;
            this.formatIsRegistered = formatIsRegistered;
        }
    }

    private static class AssetGroupSemaphore {
        int numberOfGroups = 0;
        int numberOfGroupsProcessed = 0;

        AssetGroupSemaphore(int numberOfGroups) {
            this.numberOfGroups = numberOfGroups;
            this.numberOfGroupsProcessed = numberOfGroups;
        }

        synchronized void recordEmptyGroup() {
            --this.numberOfGroups;
        }

        synchronized void recordProcessedGroup() {
            --this.numberOfGroupsProcessed;
        }

        synchronized boolean areAllGroupsEmpty() {
            return this.numberOfGroups == 0;
        }

        synchronized boolean areAllGroupsProcessed() {
            return this.numberOfGroupsProcessed == 0;
        }
    }
}

