/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.AssetItem;

public class AssetTemplateCreator {
    private static final LoggingHelper log = LoggingHelper.getLogger(AssetTemplateCreator.class);

    protected void applyPreBuiltTemplates(String ruleName, String format, AssetItem asset) {
        if (format.equals("dslr")) {
            asset.updateContent("when\n\nthen\n");
        } else if (format.equals("function")) {
            asset.updateContent("function <returnType> " + ruleName + "(<args here>) {\n\n\n}");
        } else if (format.equals("dsl")) {
            asset.updateContent("[when]Condition sentence template {var}=rule language mapping {var}\n[then]Action sentence template=rule language mapping");
        } else if (format.equals("drl")) {
            asset.updateContent("when\n\t#conditions\nthen\n\t#actions");
        } else if (!format.equals("enumeration")) {
            if (format.equals("springContext")) {
                asset.updateContent(this.getTemplateFromFile("spring-context-sample.xml"));
            } else if (format.equals("serviceConfig")) {
                asset.updateContent("");
            } else if (format.equals("wid")) {
                asset.updateContent(this.getTemplateFromFile("workitem-definition-sample.xml"));
            } else if (format.equals("changeset")) {
                asset.updateContent(this.getTemplateFromFile("change-set-sample.xml"));
            }
        }
    }

    private String getTemplateFromFile(String fileName) {
        try {
            ByteArrayOutputStream outContent = new ByteArrayOutputStream();
            BufferedInputStream inContent = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(fileName));
            IOUtils.copy((InputStream)inContent, (OutputStream)outContent);
            return outContent.toString();
        }
        catch (IOException ex) {
            log.error("Error reading spring-context-sample.xml", ex);
            throw new IllegalArgumentException("Error " + fileName, ex);
        }
    }
}

