/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.PushResponse;
import org.jboss.seam.security.Credentials;
import org.jboss.solder.servlet.http.HttpSessionStatus;

@ApplicationScoped
public class Backchannel {
    private final List<CountDownLatch> waiting = Collections.synchronizedList(new ArrayList());
    private final Map<String, List<PushResponse>> mailbox = Collections.synchronizedMap(new HashMap());
    private final Timer timer = new Timer(true);
    @Inject
    private Credentials credentials;
    @Inject
    private HttpSessionStatus sessionStatus;

    @PostConstruct
    public void postConstruct() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Backchannel.this.unlatchAllWaiting();
            }
        }, 20000L, 30000L);
    }

    public List<PushResponse> subscribe() {
        if (this.sessionStatus.isActive()) {
            try {
                return this.await(this.credentials.getUsername());
            }
            catch (InterruptedException e) {
                return new ArrayList<PushResponse>();
            }
        }
        return new ArrayList<PushResponse>();
    }

    public List<PushResponse> await(String userName) throws InterruptedException {
        List<PushResponse> messages = this.fetchMessageForUser(userName);
        if (messages != null && messages.size() > 0) {
            return messages;
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.waiting.add(latch);
        latch.await(10800L, TimeUnit.SECONDS);
        return this.fetchMessageForUser(userName);
    }

    private List<PushResponse> fetchMessageForUser(String userName) {
        return this.mailbox.put(userName, new ArrayList());
    }

    public synchronized void push(String userName, PushResponse message) {
        List<PushResponse> resp = this.mailbox.get(userName);
        if (resp == null) {
            resp = new ArrayList<PushResponse>();
            resp.add(message);
            this.mailbox.put(userName, resp);
        } else {
            resp.add(message);
        }
        this.unlatchAllWaiting();
    }

    public synchronized void publish(PushResponse message) {
        for (Map.Entry<String, List<PushResponse>> e : this.mailbox.entrySet()) {
            if (e.getValue() == null) {
                e.setValue(new ArrayList());
            }
            e.getValue().add(message);
        }
        this.unlatchAllWaiting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlatchAllWaiting() {
        List<CountDownLatch> list = this.waiting;
        synchronized (list) {
            Iterator<CountDownLatch> it = this.waiting.iterator();
            while (it.hasNext()) {
                CountDownLatch l = it.next();
                l.countDown();
                it.remove();
            }
        }
    }
}

