/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.CategoryFilter;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.util.QueryPageRowCreator;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.RepositoryFilter;
import org.jboss.seam.security.Identity;

public class QuickFindPageRowBuilder
implements PageRowBuilder<PageRequest, Iterator<AssetItem>> {
    private PageRequest pageRequest;
    private Iterator<AssetItem> iterator;
    private Identity identity;

    @Override
    public List<QueryPageRow> build() {
        this.validate();
        int skipped = 0;
        Integer pageSize = this.pageRequest.getPageSize();
        int startRowIndex = this.pageRequest.getStartRowIndex();
        AssetItemFilter filter = new AssetItemFilter(this.identity);
        CategoryFilter categoryFilter = new CategoryFilter(this.identity);
        ArrayList<QueryPageRow> rowList = new ArrayList<QueryPageRow>();
        while (this.iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            AssetItem assetItem = this.iterator.next();
            if (!filter.accept(assetItem, RoleType.PACKAGE_READONLY.getName()) && !this.checkCategoryPermissionHelper(categoryFilter, assetItem, RoleType.ANALYST_READ.getName())) continue;
            if (skipped >= startRowIndex) {
                rowList.add(QueryPageRowCreator.makeQueryPageRow(assetItem));
            }
            ++skipped;
        }
        return rowList;
    }

    private boolean checkCategoryPermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        List tempCateList = item.getCategories();
        for (CategoryItem categoryItem : tempCateList) {
            if (!filter.accept((Object)categoryItem.getFullPath(), roleType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.iterator == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public QuickFindPageRowBuilder withPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public QuickFindPageRowBuilder withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public QuickFindPageRowBuilder withContent(Iterator<AssetItem> iterator) {
        this.iterator = iterator;
        return this;
    }
}

