/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.RepositoryModuleService;
import org.drools.repository.ModuleItem;
import org.drools.repository.ModuleIterator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;

public class ActionsAPI {
    public void post(RepositoryModuleService service, RulesRepository repository, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String packageName = request.getParameter(Parameters.PackageName.toString());
            String[] pathstr = this.split(request.getRequestURI());
            if (pathstr[0].equals("compile")) {
                if (repository.containsModule(packageName)) {
                    ModuleIterator iter = repository.listModules();
                    while (iter.hasNext()) {
                        ModuleItem p = iter.next();
                        if (!p.getName().equals(packageName)) continue;
                        String uuid = p.getUUID();
                        service.buildPackage(uuid, true);
                        break;
                    }
                }
            } else if (pathstr[0].equals("snapshot")) {
                if (repository.containsModule(packageName)) {
                    String snapshotName = request.getParameter(Parameters.SnapshotName.toString());
                    repository.createModuleSnapshot(packageName, snapshotName);
                }
            } else {
                throw new RulesRepositoryException("Unknown action request: " + request.getContextPath());
            }
            response.setContentType("text/html");
            response.setStatus(200);
            response.getWriter().write("OK");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    String[] split(String path) throws UnsupportedEncodingException {
        if (path.contains("action")) {
            path = path.split("action")[1];
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] bits = path.split("/");
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = URLDecoder.decode(bits[i], "UTF-8");
        }
        return bits;
    }

    public static enum Parameters {
        PackageName{

            public String toString() {
                return "package-name";
            }
        }
        ,
        SnapshotName{

            public String toString() {
                return "snapshot-name";
            }
        };

    }
}

