/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.files.Response;
import org.drools.guvnor.server.files.RestAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAPIServlet
extends RepositoryServlet {
    private static final long serialVersionUID = 510L;
    public static final Logger log = LoggerFactory.getLogger(RestAPIServlet.class);
    @Inject
    private RestAPI restAPI;

    protected void doPost(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, new RepositoryServlet.Command(){

            @Override
            public void execute() throws Exception {
                res.setContentType("text/html");
                RestAPI api = RestAPIServlet.this.getAPI();
                String comment = req.getHeader("Checkin-Comment");
                api.post(req.getRequestURI(), (InputStream)req.getInputStream(), comment != null ? comment : "");
                res.getWriter().write("OK");
            }
        });
    }

    protected void doGet(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, new RepositoryServlet.Command(){

            @Override
            public void execute() throws Exception {
                RestAPI api = RestAPIServlet.this.getAPI();
                String qString = req.getQueryString();
                String ur = req.getRequestURI();
                if (qString != null && qString.length() > 0) {
                    ur = ur + '?' + qString;
                }
                Response apiRes = api.get(ur);
                res.setContentType("application/x-download");
                res.setHeader("Content-Disposition", "attachment; filename=data;");
                apiRes.writeData((OutputStream)res.getOutputStream());
                res.getOutputStream().flush();
            }
        });
    }

    protected void doPut(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, new RepositoryServlet.Command(){

            @Override
            public void execute() throws Exception {
                res.setContentType("text/html");
                RestAPI api = RestAPIServlet.this.getAPI();
                String comment = req.getHeader("Checkin-Comment");
                Calendar lastMod = RestAPIServlet.this.getModified(req.getHeader("Last-Modified"));
                api.put(req.getRequestURI(), lastMod, (InputStream)req.getInputStream(), comment != null ? comment : "");
                res.getWriter().write("OK");
            }
        });
    }

    Calendar getModified(String f) throws ParseException {
        if (f == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        SimpleDateFormat sdf = RestAPI.getISODateFormat();
        try {
            c.setTime(sdf.parse(f));
        }
        catch (ParseException e) {
            DateFormat df = DateFormat.getInstance();
            c.setTime(df.parse(f));
        }
        return c;
    }

    protected void doDelete(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, new RepositoryServlet.Command(){

            @Override
            public void execute() throws Exception {
                res.setContentType("text/html");
                RestAPI api = RestAPIServlet.this.getAPI();
                api.delete(req.getRequestURI());
                res.getWriter().write("OK");
            }
        });
    }

    RestAPI getAPI() {
        return this.restAPI;
    }
}

