/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.ModelNameHelper;
import org.drools.guvnor.client.asseteditor.drools.factmodel.NoSpaceKeyPressHandler;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;

public class FactEditorPopup {
    public static final Comparator<FactMetaModel> byNameAscendingComparator = new Comparator<FactMetaModel>(){

        @Override
        public int compare(FactMetaModel o1, FactMetaModel o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final RegExp VALID_NAME = RegExp.compile((String)"^[a-zA-Z][a-zA-Z\\d_$]*$");
    private final FactMetaModel factModel;
    private final List<FactMetaModel> superTypeFactModels;
    private final ModelNameHelper modelNameHelper;
    private final ListBox lstSuperTypes = new ListBox();
    private Command okCommand;

    public FactEditorPopup(ModelNameHelper modelNameHelper, List<FactMetaModel> superTypeFactModels) {
        this(new FactMetaModel(), superTypeFactModels, modelNameHelper);
    }

    public FactEditorPopup(FactMetaModel factModel, List<FactMetaModel> superTypeFactModels, ModelNameHelper modelNameHelper) {
        this.factModel = factModel;
        this.superTypeFactModels = superTypeFactModels;
        this.modelNameHelper = modelNameHelper;
    }

    public FactMetaModel getFactModel() {
        return this.factModel;
    }

    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    public void show() {
        final FormStylePopup pop = new FormStylePopup();
        pop.setTitle(Constants.INSTANCE.Name());
        HorizontalPanel changeName = new HorizontalPanel();
        final TextBox name = new TextBox();
        name.setText(this.factModel.getName());
        changeName.add((Widget)name);
        int selectedIndex = 0;
        this.lstSuperTypes.addItem(Constants.INSTANCE.DoesNotExtend());
        Collections.sort(this.superTypeFactModels, byNameAscendingComparator);
        for (FactMetaModel fmm : this.superTypeFactModels) {
            if (fmm.getName().equals(this.factModel.getName())) continue;
            this.lstSuperTypes.addItem(fmm.getName());
            if (this.factModel.getSuperType() == null || !this.factModel.getSuperType().equals(fmm.getName())) continue;
            selectedIndex = this.lstSuperTypes.getItemCount() - 1;
        }
        this.lstSuperTypes.setSelectedIndex(selectedIndex);
        if (this.lstSuperTypes.getItemCount() == 1) {
            this.lstSuperTypes.setEnabled(false);
        }
        this.lstSuperTypes.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (FactEditorPopup.this.lstSuperTypes.getSelectedIndex() <= 0) {
                    FactEditorPopup.this.factModel.setSuperType(null);
                } else {
                    String oldSuperType = FactEditorPopup.this.factModel.getSuperType();
                    String newSuperType = FactEditorPopup.this.lstSuperTypes.getItemText(FactEditorPopup.this.lstSuperTypes.getSelectedIndex());
                    FactEditorPopup.this.factModel.setSuperType(newSuperType);
                    if (FactEditorPopup.this.createsCircularDependency(newSuperType)) {
                        Window.alert((String)Constants.INSTANCE.CreatesCircularDependency(name.getText()));
                        FactEditorPopup.this.factModel.setSuperType(oldSuperType);
                        FactEditorPopup.this.lstSuperTypes.setSelectedIndex(FactEditorPopup.this.getSelectedIndex(oldSuperType));
                        return;
                    }
                    FactEditorPopup.this.factModel.setSuperType(newSuperType);
                }
            }
        });
        Button nameButton = new Button(Constants.INSTANCE.OK());
        nameButton.addKeyPressHandler((KeyPressHandler)new NoSpaceKeyPressHandler());
        nameButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String factName = name.getText();
                if (!this.isNameValid(factName)) {
                    Window.alert((String)Constants.INSTANCE.InvalidModelName(factName));
                    return;
                }
                if (this.doesTheNameExist(factName)) {
                    Window.alert((String)Constants.INSTANCE.NameTakenForModel(factName));
                    return;
                }
                if (this.factModelAlreadyHasAName(factName)) {
                    if (this.isTheUserSureHeWantsToChangeTheName()) {
                        this.setNameAndClose();
                    }
                } else {
                    this.setNameAndClose();
                }
            }

            private boolean isNameValid(String name2) {
                if (name2 == null || "".equals(name2)) {
                    return false;
                }
                return VALID_NAME.test(name2);
            }

            private boolean factModelAlreadyHasAName(String name2) {
                return FactEditorPopup.this.factModel.getName() != null && !FactEditorPopup.this.factModel.getName().equals(name2);
            }

            private void setNameAndClose() {
                String oldName = FactEditorPopup.this.factModel.getName();
                String newName = name.getText();
                FactEditorPopup.this.modelNameHelper.changeNameInModelNameHelper(oldName, newName);
                FactEditorPopup.this.factModel.setName(newName);
                FactEditorPopup.this.okCommand.execute();
                pop.hide();
            }

            private boolean isTheUserSureHeWantsToChangeTheName() {
                return Window.confirm((String)Constants.INSTANCE.ModelNameChangeWarning());
            }

            private boolean doesTheNameExist(String name2) {
                if (FactEditorPopup.this.factModel.getName() != null && FactEditorPopup.this.factModel.getName().equals(name2)) {
                    return false;
                }
                return !FactEditorPopup.this.modelNameHelper.isUniqueName(name2);
            }
        });
        pop.addAttribute(Constants.INSTANCE.Name(), (Widget)changeName);
        pop.addAttribute(Constants.INSTANCE.TypeExtends(), (Widget)this.lstSuperTypes);
        pop.addRow((Widget)nameButton);
        pop.show();
    }

    private int getSelectedIndex(String superType) {
        if (superType == null) {
            return 0;
        }
        for (int i = 1; i < this.lstSuperTypes.getItemCount(); ++i) {
            if (!superType.equals(this.lstSuperTypes.getItemText(i))) continue;
            return i;
        }
        return 0;
    }

    private boolean createsCircularDependency(String type) {
        HashSet<String> circulars = new HashSet<String>();
        FactMetaModel fmm = this.getFactMetaModel(type);
        return this.addCircular(fmm, circulars);
    }

    private boolean addCircular(FactMetaModel fmm, Set<String> circulars) {
        if (!fmm.hasSuperType()) {
            return false;
        }
        String type = fmm.getName();
        if (circulars.contains(type)) {
            return true;
        }
        circulars.add(type);
        FactMetaModel efmm = this.getFactMetaModel(fmm.getSuperType());
        return this.addCircular(efmm, circulars);
    }

    private FactMetaModel getFactMetaModel(String type) {
        for (FactMetaModel fmm : this.superTypeFactModels) {
            if (!fmm.getName().equals(type)) continue;
            return fmm;
        }
        return null;
    }
}

