/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.IBindingProvider;
import org.drools.guvnor.client.decisiontable.DTCellValueWidgetFactory;
import org.drools.guvnor.client.decisiontable.GenericColumnCommand;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.WorkItemService;
import org.drools.guvnor.client.rpc.WorkItemServiceAsync;
import org.drools.guvnor.client.widgets.drools.workitems.WorkItemParametersWidget;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.shared.workitems.PortableBooleanParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableEnumParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableFloatParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableIntegerParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableListParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableObjectParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableStringParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableWorkDefinition;

public class ActionWorkItemPopup
extends FormStylePopup {
    private ActionWorkItemCol52 editingCol;
    private String packageUUID;
    private GuidedDecisionTable52 model;
    private ClientFactory clientFactory;
    private WorkItemParametersWidget workItemInputParameters;
    private int workItemInputParametersIndex;
    private Map<String, PortableWorkDefinition> workItemDefinitions;
    private final boolean isReadOnly;

    public ActionWorkItemPopup(ClientFactory clientFactory, String packageUUID, GuidedDecisionTable52 model, IBindingProvider bindingProvider, final GenericColumnCommand refreshGrid, final ActionWorkItemCol52 col, final boolean isNew, boolean isReadOnly) {
        this.editingCol = this.cloneActionWorkItemColumn(col);
        this.clientFactory = clientFactory;
        this.packageUUID = packageUUID;
        this.model = model;
        this.isReadOnly = isReadOnly;
        this.workItemInputParameters = new WorkItemParametersWidget(bindingProvider, isReadOnly);
        this.setTitle(Constants.INSTANCE.ColumnConfigurationWorkItem());
        this.setModal(false);
        final TextBox header = new TextBox();
        header.setText(col.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ActionWorkItemPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(Constants.INSTANCE.ColumnHeaderDescription(), (Widget)header);
        final ListBox workItemsListBox = new ListBox();
        this.addAttribute(Constants.INSTANCE.WorkItemNameColon(), (Widget)workItemsListBox);
        this.setupWorkItems(workItemsListBox);
        workItemsListBox.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            workItemsListBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    int index = workItemsListBox.getSelectedIndex();
                    if (index >= 0) {
                        String selectedWorkItemName = workItemsListBox.getValue(index);
                        ActionWorkItemPopup.this.editingCol.setWorkItemDefinition((PortableWorkDefinition)ActionWorkItemPopup.this.workItemDefinitions.get(selectedWorkItemName));
                        ActionWorkItemPopup.this.showWorkItemParameters();
                        ActionWorkItemPopup.this.center();
                    }
                }
            });
        }
        this.workItemInputParametersIndex = this.addAttribute(Constants.INSTANCE.WorkItemInputParameters(), (Widget)this.workItemInputParameters, false);
        this.addAttribute(Constants.INSTANCE.HideThisColumn(), (Widget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        Button apply = new Button(Constants.INSTANCE.ApplyChanges());
        apply.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (null == ActionWorkItemPopup.this.editingCol.getHeader() || "".equals(ActionWorkItemPopup.this.editingCol.getHeader())) {
                    Window.alert((String)Constants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
                    return;
                }
                if (isNew) {
                    if (!ActionWorkItemPopup.this.unique(ActionWorkItemPopup.this.editingCol.getHeader())) {
                        Window.alert((String)Constants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                        return;
                    }
                } else if (!col.getHeader().equals(ActionWorkItemPopup.this.editingCol.getHeader()) && !ActionWorkItemPopup.this.unique(ActionWorkItemPopup.this.editingCol.getHeader())) {
                    Window.alert((String)Constants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                    return;
                }
                refreshGrid.execute((DTColumnConfig52)ActionWorkItemPopup.this.editingCol);
                ActionWorkItemPopup.this.hide();
            }
        });
        this.addAttribute("", (Widget)apply);
    }

    private boolean unique(String header) {
        for (ActionCol52 o : this.model.getActionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }

    private ActionWorkItemCol52 cloneActionWorkItemColumn(ActionWorkItemCol52 col) {
        ActionWorkItemCol52 clone = new ActionWorkItemCol52();
        clone.setHeader(col.getHeader());
        clone.setHideColumn(col.isHideColumn());
        clone.setWorkItemDefinition(this.cloneWorkItemDefinition(col.getWorkItemDefinition()));
        return clone;
    }

    private PortableWorkDefinition cloneWorkItemDefinition(PortableWorkDefinition pwd) {
        if (pwd == null) {
            return null;
        }
        PortableWorkDefinition clone = new PortableWorkDefinition();
        clone.setName(pwd.getName());
        clone.setDisplayName(pwd.getDisplayName());
        clone.setParameters(this.cloneParameters(pwd.getParameters()));
        clone.setResults(this.cloneParameters(pwd.getResults()));
        return clone;
    }

    private Set<PortableParameterDefinition> cloneParameters(Set<PortableParameterDefinition> parameters) {
        HashSet<PortableParameterDefinition> clone = new HashSet<PortableParameterDefinition>();
        for (PortableParameterDefinition ppd : parameters) {
            clone.add(this.cloneParameter(ppd));
        }
        return clone;
    }

    private PortableParameterDefinition cloneParameter(PortableParameterDefinition ppd) {
        PortableBooleanParameterDefinition clone = null;
        if (ppd instanceof PortableBooleanParameterDefinition) {
            clone = new PortableBooleanParameterDefinition();
            clone.setName(ppd.getName());
            clone.setBinding(((PortableBooleanParameterDefinition)ppd).getBinding());
            clone.setValue(((PortableBooleanParameterDefinition)ppd).getValue());
            return clone;
        }
        if (ppd instanceof PortableEnumParameterDefinition) {
            clone = new PortableEnumParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableEnumParameterDefinition)clone).setClassName(((PortableEnumParameterDefinition)ppd).getClassName());
            ((PortableEnumParameterDefinition)clone).setBinding(((PortableEnumParameterDefinition)ppd).getBinding());
            ((PortableEnumParameterDefinition)clone).setValues(((PortableEnumParameterDefinition)ppd).getValues());
            ((PortableEnumParameterDefinition)clone).setValue(((PortableEnumParameterDefinition)ppd).getValue());
            return clone;
        }
        if (ppd instanceof PortableFloatParameterDefinition) {
            clone = new PortableFloatParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableFloatParameterDefinition)clone).setBinding(((PortableFloatParameterDefinition)ppd).getBinding());
            ((PortableFloatParameterDefinition)clone).setValue(((PortableFloatParameterDefinition)ppd).getValue());
            return clone;
        }
        if (ppd instanceof PortableIntegerParameterDefinition) {
            clone = new PortableIntegerParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableIntegerParameterDefinition)clone).setBinding(((PortableIntegerParameterDefinition)ppd).getBinding());
            ((PortableIntegerParameterDefinition)clone).setValue(((PortableIntegerParameterDefinition)ppd).getValue());
            return clone;
        }
        if (ppd instanceof PortableListParameterDefinition) {
            clone = new PortableListParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableListParameterDefinition)clone).setBinding(((PortableListParameterDefinition)ppd).getBinding());
            ((PortableListParameterDefinition)clone).setClassName(((PortableListParameterDefinition)ppd).getClassName());
            return clone;
        }
        if (ppd instanceof PortableObjectParameterDefinition) {
            clone = new PortableObjectParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableObjectParameterDefinition)clone).setBinding(((PortableObjectParameterDefinition)ppd).getBinding());
            ((PortableObjectParameterDefinition)clone).setClassName(((PortableObjectParameterDefinition)ppd).getClassName());
            return clone;
        }
        if (ppd instanceof PortableStringParameterDefinition) {
            clone = new PortableStringParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableStringParameterDefinition)clone).setBinding(((PortableStringParameterDefinition)ppd).getBinding());
            ((PortableStringParameterDefinition)clone).setValue(((PortableStringParameterDefinition)ppd).getValue());
            return clone;
        }
        throw new IllegalArgumentException("Unrecognized PortableParameterDefinition");
    }

    private void setupWorkItems(final ListBox workItemsListBox) {
        workItemsListBox.clear();
        workItemsListBox.addItem(Constants.INSTANCE.NoWorkItemsAvailable());
        workItemsListBox.setEnabled(false);
        WorkItemServiceAsync workItemService = (WorkItemServiceAsync)GWT.create(WorkItemService.class);
        workItemService.loadWorkItemDefinitions(this.packageUUID, (AsyncCallback<Set<PortableWorkDefinition>>)new GenericCallback<Set<PortableWorkDefinition>>(){

            public void onSuccess(Set<PortableWorkDefinition> result) {
                if (result.size() > 0) {
                    workItemsListBox.clear();
                    workItemsListBox.setEnabled(!ActionWorkItemPopup.this.isReadOnly);
                    workItemsListBox.addItem(Constants.INSTANCE.pleaseChoose(), "");
                    ActionWorkItemPopup.this.workItemDefinitions = new HashMap();
                    String selectedName = null;
                    boolean isWorkItemSelected = false;
                    if (ActionWorkItemPopup.this.editingCol.getWorkItemDefinition() != null) {
                        selectedName = ActionWorkItemPopup.this.editingCol.getWorkItemDefinition().getName();
                    }
                    int i = 0;
                    for (PortableWorkDefinition wid : result) {
                        workItemsListBox.addItem(wid.getDisplayName(), wid.getName());
                        ActionWorkItemPopup.this.workItemDefinitions.put(wid.getName(), wid);
                        if (wid.getName().equals(selectedName)) {
                            workItemsListBox.setSelectedIndex(i + 1);
                            isWorkItemSelected = true;
                        }
                        ++i;
                    }
                    ActionWorkItemPopup.this.setAttributeVisibility(ActionWorkItemPopup.this.workItemInputParametersIndex, isWorkItemSelected);
                    ActionWorkItemPopup.this.showWorkItemParameters();
                    ActionWorkItemPopup.this.center();
                }
            }
        });
    }

    private void showWorkItemParameters() {
        PortableWorkDefinition wid = this.editingCol.getWorkItemDefinition();
        if (wid == null) {
            this.setAttributeVisibility(this.workItemInputParametersIndex, false);
            return;
        }
        this.setAttributeVisibility(this.workItemInputParametersIndex, true);
        this.workItemInputParameters.setParameters(wid.getParameters());
    }
}

