/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.drools.guvnor.client.util.DateConverter;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class DTCellValueUtilities {
    protected static DateConverter DATE_CONVERTOR = null;
    private final GuidedDecisionTable52 model;
    private final SuggestionCompletionEngine sce;

    public static void injectDateConvertor(DateConverter dc) {
        DATE_CONVERTOR = dc;
    }

    public DTCellValueUtilities(GuidedDecisionTable52 model, SuggestionCompletionEngine sce) {
        this.model = model;
        this.sce = sce;
    }

    public DTDataTypes52 getDataType(BaseColumn column) {
        ConditionCol52 cc;
        if (column instanceof LimitedEntryCol) {
            return DTDataTypes52.BOOLEAN;
        }
        if (column instanceof ActionWorkItemCol52) {
            return DTDataTypes52.BOOLEAN;
        }
        if (column instanceof ActionWorkItemSetFieldCol52 || column instanceof ActionWorkItemInsertFactCol52) {
            return DTDataTypes52.BOOLEAN;
        }
        if (column instanceof ConditionCol52 && (cc = (ConditionCol52)column).getOperator() != null && (cc.getOperator().equals("== null") || cc.getOperator().equals("!= null"))) {
            return DTDataTypes52.BOOLEAN;
        }
        return this.model.getTypeSafeType(column, this.sce);
    }

    public DTDataTypes52 getDataType(Pattern52 pattern, ConditionCol52 condition) {
        if (condition instanceof LimitedEntryCol) {
            return DTDataTypes52.BOOLEAN;
        }
        if (condition.getOperator() != null && (condition.getOperator().equals("== null") || condition.getOperator().equals("!= null"))) {
            return DTDataTypes52.BOOLEAN;
        }
        return this.model.getTypeSafeType(pattern, condition, this.sce);
    }

    public DTDataTypes52 getDataType(Pattern52 pattern, ActionSetFieldCol52 action) {
        if (action instanceof LimitedEntryCol) {
            return DTDataTypes52.BOOLEAN;
        }
        return this.model.getTypeSafeType(pattern, action, this.sce);
    }

    public void assertDTCellValue(DTDataTypes52 dataType, DTCellValue52 dcv) {
        if (dcv == null) {
            return;
        }
        if (dataType.equals((Object)dcv.getDataType())) {
            return;
        }
        switch (dcv.getDataType()) {
            case NUMERIC: {
                this.convertDTCellValueFromNumeric(dataType, dcv);
                break;
            }
            default: {
                this.convertDTCellValueFromString(dataType, dcv);
            }
        }
    }

    public String asString(DTCellValue52 dcv) {
        switch (dcv.getDataType()) {
            case BOOLEAN: {
                return this.convertBooleanValueToString(dcv);
            }
            case DATE: {
                return this.convertDateValueToString(dcv);
            }
            case NUMERIC: {
                return this.convertNumericValueToString(dcv);
            }
            case NUMERIC_BIGDECIMAL: {
                return this.convertBigDecimalValueToString(dcv);
            }
            case NUMERIC_BIGINTEGER: {
                return this.convertBigIntegerValueToString(dcv);
            }
            case NUMERIC_BYTE: {
                return this.convertByteValueToString(dcv);
            }
            case NUMERIC_DOUBLE: {
                return this.convertDoubleValueToString(dcv);
            }
            case NUMERIC_FLOAT: {
                return this.convertFloatValueToString(dcv);
            }
            case NUMERIC_INTEGER: {
                return this.convertIntegerValueToString(dcv);
            }
            case NUMERIC_LONG: {
                return this.convertLongValueToString(dcv);
            }
            case NUMERIC_SHORT: {
                return this.convertShortValueToString(dcv);
            }
        }
        return this.convertStringValueToString(dcv);
    }

    private String convertBooleanValueToString(DTCellValue52 dcv) {
        Boolean value = dcv.getBooleanValue();
        return value == null ? "" : value.toString();
    }

    private String convertDateValueToString(DTCellValue52 dcv) {
        Date value = dcv.getDateValue();
        String result = "";
        if (value != null) {
            result = DATE_CONVERTOR.format(value);
        }
        return result;
    }

    private String convertNumericValueToString(DTCellValue52 dcv) {
        BigDecimal value = (BigDecimal)dcv.getNumericValue();
        return value == null ? "" : value.toPlainString();
    }

    private String convertBigDecimalValueToString(DTCellValue52 dcv) {
        BigDecimal value = (BigDecimal)dcv.getNumericValue();
        return value == null ? "" : value.toPlainString();
    }

    private String convertBigIntegerValueToString(DTCellValue52 dcv) {
        BigInteger value = (BigInteger)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertByteValueToString(DTCellValue52 dcv) {
        Byte value = (Byte)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertDoubleValueToString(DTCellValue52 dcv) {
        Double value = (Double)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertFloatValueToString(DTCellValue52 dcv) {
        Float value = (Float)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertIntegerValueToString(DTCellValue52 dcv) {
        Integer value = (Integer)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertLongValueToString(DTCellValue52 dcv) {
        Long value = (Long)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertShortValueToString(DTCellValue52 dcv) {
        Short value = (Short)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertStringValueToString(DTCellValue52 dcv) {
        String value = dcv.getStringValue();
        return value == null ? "" : value;
    }

    private void convertDTCellValueFromString(DTDataTypes52 dataType, DTCellValue52 dcv) {
        String text = dcv.getStringValue();
        switch (dataType) {
            case BOOLEAN: {
                dcv.setBooleanValue(Boolean.valueOf(text == null ? false : Boolean.valueOf(text)));
                break;
            }
            case DATE: {
                Date d = null;
                try {
                    if (text != null) {
                        if (DATE_CONVERTOR == null) {
                            throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
                        }
                        d = DATE_CONVERTOR.parse(text);
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                dcv.setDateValue(d);
                break;
            }
            case NUMERIC: {
                BigDecimal numericValue = null;
                try {
                    if (text != null) {
                        numericValue = new BigDecimal(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(numericValue);
                break;
            }
            case NUMERIC_BIGDECIMAL: {
                BigDecimal bigDecimalValue = null;
                try {
                    if (text != null) {
                        bigDecimalValue = new BigDecimal(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(bigDecimalValue);
                break;
            }
            case NUMERIC_BIGINTEGER: {
                BigInteger bigIntegerValue = null;
                try {
                    if (text != null) {
                        bigIntegerValue = new BigInteger(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(bigIntegerValue);
                break;
            }
            case NUMERIC_BYTE: {
                Byte byteValue = null;
                try {
                    if (text != null) {
                        byteValue = new Byte(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(byteValue);
                break;
            }
            case NUMERIC_DOUBLE: {
                Double doubleValue = null;
                try {
                    if (text != null) {
                        doubleValue = new Double(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(doubleValue);
                break;
            }
            case NUMERIC_FLOAT: {
                Float floatValue = null;
                try {
                    if (text != null) {
                        floatValue = new Float(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(floatValue);
                break;
            }
            case NUMERIC_INTEGER: {
                Integer integerValue = null;
                try {
                    if (text != null) {
                        integerValue = new Integer(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(integerValue);
                break;
            }
            case NUMERIC_LONG: {
                Long longValue = null;
                try {
                    if (text != null) {
                        longValue = new Long(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(longValue);
                break;
            }
            case NUMERIC_SHORT: {
                Short shortValue = null;
                try {
                    if (text != null) {
                        shortValue = new Short(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(shortValue);
            }
        }
    }

    private void convertDTCellValueFromNumeric(DTDataTypes52 dataType, DTCellValue52 dcv) {
        BigDecimal value = (BigDecimal)dcv.getNumericValue();
        switch (dataType) {
            case NUMERIC_BIGDECIMAL: {
                dcv.setNumericValue(value == null ? null : value);
                break;
            }
            case NUMERIC_BIGINTEGER: {
                dcv.setNumericValue(value == null ? null : value.toBigInteger());
                break;
            }
            case NUMERIC_BYTE: {
                dcv.setNumericValue(value == null ? null : Byte.valueOf(value.byteValue()));
                break;
            }
            case NUMERIC_DOUBLE: {
                dcv.setNumericValue(value == null ? null : Double.valueOf(value.doubleValue()));
                break;
            }
            case NUMERIC_FLOAT: {
                dcv.setNumericValue(value == null ? null : Float.valueOf(value.floatValue()));
                break;
            }
            case NUMERIC_INTEGER: {
                dcv.setNumericValue(value == null ? null : Integer.valueOf(value.intValue()));
                break;
            }
            case NUMERIC_LONG: {
                dcv.setNumericValue(value == null ? null : Long.valueOf(value.longValue()));
                break;
            }
            case NUMERIC_SHORT: {
                dcv.setNumericValue(value == null ? null : Short.valueOf(value.shortValue()));
            }
        }
    }
}

