/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.decisiontable.widget.LimitedEntryDropDownManager;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.client.modeldriven.ui.ConstraintValueEditorHelper;

public class RowExpander {
    private Map<BaseColumn, ColumnValues> expandedColumns = new IdentityHashMap<BaseColumn, ColumnValues>();
    private List<ColumnValues> columns;
    private final GuidedDecisionTable52 dtable;
    private final SuggestionCompletionEngine sce;
    private static final List<DTCellValue52> EMPTY_VALUE = new ArrayList<DTCellValue52>();

    RowExpander(GuidedDecisionTable52 dtable, SuggestionCompletionEngine sce) {
        EMPTY_VALUE.add(new DTCellValue52());
        this.columns = new ArrayList<ColumnValues>();
        this.dtable = dtable;
        this.sce = sce;
        this.addRowNumberColumn();
        this.addRowDescriptionColumn();
        this.addConditionColumns();
        this.addActionColumns();
    }

    List<ColumnValues> getColumns() {
        return this.columns;
    }

    private void addRowNumberColumn() {
        RowNumberColumnValues cv = new RowNumberColumnValues(this.columns, EMPTY_VALUE, new DTCellValue52());
        cv.setExpandColumn(false);
        this.expandedColumns.put((BaseColumn)this.dtable.getRowNumberCol(), cv);
        this.columns.add(cv);
    }

    private void addRowDescriptionColumn() {
        RowDescriptionColumnValues cv = new RowDescriptionColumnValues(this.columns, EMPTY_VALUE, new DTCellValue52());
        cv.setExpandColumn(false);
        this.expandedColumns.put((BaseColumn)this.dtable.getDescriptionCol(), cv);
        this.columns.add(cv);
    }

    private void addConditionColumns() {
        for (Pattern52 p : this.dtable.getPatterns()) {
            this.addColumn(p);
        }
    }

    private void addActionColumns() {
        for (ActionCol52 a : this.dtable.getActionCols()) {
            if (a instanceof ActionSetFieldCol52) {
                ActionSetFieldCol52 afc = (ActionSetFieldCol52)a;
                this.addColumn(afc);
                continue;
            }
            if (!(a instanceof ActionInsertFactCol52)) continue;
            ActionInsertFactCol52 aif = (ActionInsertFactCol52)a;
            this.addColumn(aif);
        }
    }

    private void addColumn(Pattern52 p) {
        for (ConditionCol52 c : p.getChildColumns()) {
            this.addColumn(p, c);
        }
    }

    private void addColumn(Pattern52 p, ConditionCol52 c) {
        switch (this.dtable.getTableFormat()) {
            case EXTENDED_ENTRY: {
                this.addExtendedEntryColumn(p, c);
                break;
            }
            case LIMITED_ENTRY: {
                this.addLimitedEntryColumn(c);
            }
        }
    }

    private void addExtendedEntryColumn(Pattern52 p, ConditionCol52 c) {
        ColumnValues cv = null;
        String[] values = new String[]{};
        if (this.dtable.hasValueList(c)) {
            values = this.dtable.getValueList((BaseColumn)c);
            values = this.getSplitValues(values);
            cv = new ColumnValues(this.columns, RowExpander.convertValueList(values), c.getDefaultValue());
        } else if (this.sce.hasEnums(p.getFactType(), c.getFactField())) {
            LimitedEntryDropDownManager.Context context = new LimitedEntryDropDownManager.Context(p, c);
            cv = new ColumnDynamicValues(this.columns, this.sce, context, c.getDefaultValue());
        } else {
            cv = new ColumnValues(this.columns, RowExpander.convertValueList(values), c.getDefaultValue());
        }
        if (cv != null) {
            this.expandedColumns.put((BaseColumn)c, cv);
            this.columns.add(cv);
        }
    }

    private void addLimitedEntryColumn(ConditionCol52 c) {
        ArrayList<DTCellValue52> values = new ArrayList<DTCellValue52>();
        values.add(new DTCellValue52(Boolean.TRUE));
        values.add(new DTCellValue52(Boolean.FALSE));
        ColumnValues cv = new ColumnValues(this.columns, values, c.getDefaultValue());
        this.expandedColumns.put((BaseColumn)c, cv);
        this.columns.add(cv);
    }

    private String[] getSplitValues(String[] values) {
        String[] splitValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            String v = values[i];
            String[] splut = ConstraintValueEditorHelper.splitValue((String)v);
            splitValues[i] = splut[0];
        }
        return splitValues;
    }

    private static List<DTCellValue52> convertValueList(String[] values) {
        ArrayList<DTCellValue52> convertedValues = new ArrayList<DTCellValue52>();
        for (String value : values) {
            convertedValues.add(new DTCellValue52(value));
        }
        return convertedValues;
    }

    private void addColumn(ActionSetFieldCol52 a) {
        ColumnValues cv = new ColumnValues(this.columns, EMPTY_VALUE, this.dtable.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY ? a.getDefaultValue() : new DTCellValue52(Boolean.FALSE));
        cv.setExpandColumn(false);
        this.expandedColumns.put((BaseColumn)a, cv);
        this.columns.add(cv);
    }

    private void addColumn(ActionInsertFactCol52 a) {
        ColumnValues cv = new ColumnValues(this.columns, EMPTY_VALUE, this.dtable.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY ? a.getDefaultValue() : new DTCellValue52(Boolean.FALSE));
        cv.setExpandColumn(false);
        this.expandedColumns.put((BaseColumn)a, cv);
        this.columns.add(cv);
    }

    RowIterator iterator() {
        return new RowIterator();
    }

    void setExpandColumn(BaseColumn column, boolean expandColumn) {
        ColumnValues cv = this.expandedColumns.get(column);
        if (cv == null) {
            return;
        }
        cv.setExpandColumn(expandColumn);
    }

    static class RowDescriptionColumnValues
    extends ColumnValues {
        RowDescriptionColumnValues(List<ColumnValues> columns, List<DTCellValue52> values, DTCellValue52 defaultValue) {
            super(columns, values, defaultValue);
        }

        @Override
        DTCellValue52 getCurrentValue() {
            return new DTCellValue52();
        }
    }

    static class RowNumberColumnValues
    extends ColumnValues {
        RowNumberColumnValues(List<ColumnValues> columns, List<DTCellValue52> values, DTCellValue52 defaultValue) {
            super(columns, values, defaultValue);
        }

        @Override
        DTCellValue52 getCurrentValue() {
            return new DTCellValue52();
        }
    }

    static class ColumnDynamicValues
    extends ColumnValues {
        private final LimitedEntryDropDownManager.Context context;
        private final SuggestionCompletionEngine sce;
        private boolean initialiseValueList = true;

        ColumnDynamicValues(List<ColumnValues> columns, SuggestionCompletionEngine sce, LimitedEntryDropDownManager.Context context, DTCellValue52 defaultValue) {
            super(columns, EMPTY_VALUE, defaultValue);
            this.sce = sce;
            this.context = context;
            DropDownData dd = sce.getEnums(context.getBasePattern().getFactType(), ((ConditionCol52)context.getBaseColumn()).getFactField(), new HashMap());
            if (dd != null) {
                this.originalValues = this.values = RowExpander.convertValueList(this.getSplitValues(dd.fixedList));
                this.initialiseValueList = false;
                this.isAllValuesUsed = false;
            }
            this.iterator = this.values.iterator();
            this.value = (DTCellValue52)this.iterator.next();
        }

        private String[] getSplitValues(String[] values) {
            String[] splitValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                String v = values[i];
                String[] splut = ConstraintValueEditorHelper.splitValue((String)v);
                splitValues[i] = splut[0];
            }
            return splitValues;
        }

        boolean assertValueList(List<DTCellValue52> row) {
            if (!this.expandColumn) {
                return false;
            }
            boolean refreshRow = this.initialiseValueList;
            if (refreshRow) {
                HashMap<String, String> currentValueMap = new HashMap<String, String>();
                for (int iCol = 0; iCol < this.columns.size(); ++iCol) {
                    ColumnValues cv = (ColumnValues)this.columns.get(iCol);
                    if (!(cv instanceof ColumnDynamicValues)) continue;
                    ColumnDynamicValues cdv = (ColumnDynamicValues)cv;
                    if (!cdv.context.getBasePattern().equals(this.context.getBasePattern())) continue;
                    ConditionCol52 cc = (ConditionCol52)cdv.context.getBaseColumn();
                    DTCellValue52 value = row.get(iCol);
                    if (value == null) continue;
                    currentValueMap.put(cc.getFactField(), value.getStringValue());
                }
                this.initialiseValueList = false;
                DropDownData dd = this.sce.getEnums(this.context.getBasePattern().getFactType(), ((ConditionCol52)this.context.getBaseColumn()).getFactField(), currentValueMap);
                if (dd != null) {
                    this.originalValues = this.values = RowExpander.convertValueList(this.getSplitValues(dd.fixedList));
                    this.isAllValuesUsed = false;
                } else {
                    this.values = new ArrayList();
                    this.values.add(this.defaultValue);
                    this.originalValues = this.values;
                    this.isAllValuesUsed = true;
                }
                this.iterator = this.values.iterator();
                this.value = (DTCellValue52)this.iterator.next();
            }
            return refreshRow;
        }

        @Override
        void advanceColumnValue() {
            if (this.iterator.hasNext()) {
                this.value = (DTCellValue52)this.iterator.next();
            } else {
                this.isAllValuesUsed = true;
                this.initialiseValueList = true;
                this.iterator = this.values.iterator();
                this.value = (DTCellValue52)this.iterator.next();
                int myIndex = this.columns.indexOf(this);
                if (myIndex > 0) {
                    ((ColumnValues)this.columns.get(myIndex - 1)).advanceColumnValue();
                }
            }
        }
    }

    static class ColumnValues {
        List<DTCellValue52> values;
        List<DTCellValue52> originalValues;
        List<ColumnValues> columns;
        DTCellValue52 value;
        DTCellValue52 defaultValue;
        Iterator<DTCellValue52> iterator;
        boolean expandColumn = true;
        boolean isAllValuesUsed = false;

        ColumnValues(List<ColumnValues> columns, List<DTCellValue52> values, DTCellValue52 defaultValue) {
            this.columns = columns;
            this.defaultValue = defaultValue;
            this.values = values;
            this.originalValues = this.values;
            if (this.values.size() == 0) {
                this.values = new ArrayList<DTCellValue52>();
                this.values.add(defaultValue);
                this.originalValues = this.values;
                this.isAllValuesUsed = true;
            }
            this.iterator = this.values.iterator();
            this.value = this.iterator.next();
        }

        void setExpandColumn(boolean expandColumn) {
            this.expandColumn = expandColumn;
            if (expandColumn) {
                this.values = this.originalValues;
                this.isAllValuesUsed = false;
            } else {
                this.values = new ArrayList<DTCellValue52>();
                this.values.add(this.defaultValue);
                this.isAllValuesUsed = true;
            }
            this.iterator = this.values.iterator();
            this.value = this.iterator.next();
        }

        DTCellValue52 getCurrentValue() {
            return this.value;
        }

        void advanceColumnValue() {
            if (this.iterator.hasNext()) {
                this.value = this.iterator.next();
            } else {
                this.isAllValuesUsed = true;
                this.iterator = this.values.iterator();
                this.value = this.iterator.next();
                int myIndex = this.columns.indexOf(this);
                if (myIndex > 0) {
                    this.columns.get(myIndex - 1).advanceColumnValue();
                }
            }
        }

        boolean isAllValuesUsed() {
            return this.isAllValuesUsed;
        }
    }

    class RowIterator
    implements Iterator<List<DTCellValue52>> {
        RowIterator() {
        }

        @Override
        public boolean hasNext() {
            for (ColumnValues cv : RowExpander.this.columns) {
                if (cv.isAllValuesUsed()) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<DTCellValue52> next() {
            ArrayList<DTCellValue52> row;
            boolean refreshRow = false;
            do {
                refreshRow = false;
                row = new ArrayList<DTCellValue52>();
                for (ColumnValues cv : RowExpander.this.columns) {
                    row.add(cv.getCurrentValue());
                }
                for (ColumnValues cv : RowExpander.this.columns) {
                    if (!(cv instanceof ColumnDynamicValues)) continue;
                    ColumnDynamicValues cdv = (ColumnDynamicValues)cv;
                    refreshRow = refreshRow || cdv.assertValueList(row);
                }
            } while (refreshRow);
            ((ColumnValues)RowExpander.this.columns.get(RowExpander.this.columns.size() - 1)).advanceColumnValue();
            return row;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported on RowIterator");
        }
    }
}

