/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.Violation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Receiver<V> {
    public void onFailure(ServerFailure error) {
        if (error.isFatal()) {
            throw new RuntimeException(error.getMessage());
        }
    }

    public abstract void onSuccess(V var1);

    @Deprecated
    public void onViolation(Set<Violation> errors) {
        if (!errors.isEmpty()) {
            this.onFailure(new ServerFailure("The call failed on the server due to a ConstraintViolation"));
        }
    }

    public void onConstraintViolation(Set<ConstraintViolation<?>> violations) {
        HashSet<1> converted = new HashSet<1>();
        for (final ConstraintViolation<?> v : violations) {
            converted.add(new Violation(){

                @Override
                public BaseProxy getInvalidProxy() {
                    return (BaseProxy)v.getRootBean();
                }

                @Override
                public String getMessage() {
                    return v.getMessage();
                }

                @Override
                public BaseProxy getOriginalProxy() {
                    AutoBean parent = (AutoBean)AutoBeanUtils.getAutoBean(v.getRootBean()).getTag("parentObject");
                    return parent == null ? null : (BaseProxy)parent.as();
                }

                @Override
                public String getPath() {
                    return v.getPropertyPath().toString();
                }

                @Override
                public EntityProxyId<?> getProxyId() {
                    return v.getRootBean() instanceof EntityProxy ? ((EntityProxy)v.getRootBean()).stableId() : null;
                }
            });
        }
        this.onViolation(Collections.unmodifiableSet(converted));
    }
}

