/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import ch.qos.cal10n.MessageConveyor;
import ch.qos.cal10n.MessageConveyorException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.util.Locale;
import org.jboss.weld.logging.MessageId;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.reflection.SecureReflections;

public class WeldMessageConveyor
extends MessageConveyor {
    private static final String SEPARATOR = "-";
    private final LoadingCache<Enum<?>, String> messagePrefixCache;

    public WeldMessageConveyor(Locale locale, String subsystem) {
        super(locale);
        this.messagePrefixCache = CacheBuilder.newBuilder().build((CacheLoader)new ComputeMessagePrefix(subsystem));
    }

    public <E extends Enum<?>> String getMessage(E key, Object ... args) throws MessageConveyorException {
        return this.getMessagePrefix(key) + super.getMessage(key, args);
    }

    private <E extends Enum<?>> String getMessagePrefix(E key) {
        return LoadingCacheUtils.getCacheValue(this.messagePrefixCache, key);
    }

    private static class ComputeMessagePrefix
    extends CacheLoader<Enum<?>, String> {
        private final String subsystem;

        private ComputeMessagePrefix(String subsystem) {
            this.subsystem = subsystem;
        }

        public String load(Enum<?> from) {
            Field field;
            try {
                field = SecureReflections.getField(from.getClass(), from.name());
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("Cannot reflect on key to obtain @MessageId. Key: " + from + "; Key Type: " + from.getClass());
            }
            if (!field.isAnnotationPresent(MessageId.class)) {
                throw new IllegalArgumentException("@MessageId must be present. Key: " + from + "; Key Type: " + from.getClass());
            }
            String messageId = field.getAnnotation(MessageId.class).value();
            return this.subsystem + WeldMessageConveyor.SEPARATOR + messageId + " ";
        }
    }
}

