/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static Logger logger = LoggerFactory.getLogger(ClassUtil.class);

    public static Class forName(String className, Class caller) throws ClassNotFoundException {
        block7: {
            ClassLoader classLoader;
            block6: {
                ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                if (threadClassLoader != null) {
                    try {
                        return Class.forName(className, true, threadClassLoader);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (cnfe.getException() == null) break block6;
                        throw cnfe;
                    }
                }
            }
            if ((classLoader = caller.getClassLoader()) != null) {
                try {
                    return Class.forName(className, true, classLoader);
                }
                catch (ClassNotFoundException cnfe) {
                    if (cnfe.getException() == null) break block7;
                    throw cnfe;
                }
            }
        }
        return Class.forName(className, true, ClassLoader.getSystemClassLoader());
    }

    public static Class resolveProxy(String[] interfaces, Class caller) throws ClassNotFoundException {
        ClassLoader classLoader;
        int numInterfaces;
        int n = numInterfaces = interfaces == null ? 0 : interfaces.length;
        if (numInterfaces == 0) {
            throw new ClassNotFoundException("Cannot generate proxy with no interfaces");
        }
        Class[] interfaceClasses = new Class[numInterfaces];
        for (int count = 0; count < numInterfaces; ++count) {
            interfaceClasses[count] = ClassUtil.forName(interfaces[count], caller);
        }
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader proxyClassLoader = threadClassLoader != null ? threadClassLoader : ((classLoader = caller.getClassLoader()) != null ? classLoader : ClassLoader.getSystemClassLoader());
        return Proxy.getProxyClass(proxyClassLoader, interfaceClasses);
    }

    public static InputStream getResourceAsStream(String resourceName, Class caller) {
        InputStream is;
        InputStream is2;
        Package callerPackage;
        String resource = resourceName.startsWith("/") ? resourceName.substring(1) : ((callerPackage = caller.getPackage()) != null ? callerPackage.getName().replace('.', '/') + '/' + resourceName : resourceName);
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadClassLoader != null && (is2 = threadClassLoader.getResourceAsStream(resource)) != null) {
            return is2;
        }
        ClassLoader classLoader = caller.getClassLoader();
        if (classLoader != null && (is = classLoader.getResourceAsStream(resource)) != null) {
            return is;
        }
        return ClassLoader.getSystemResourceAsStream(resource);
    }

    public static URL getResource(String resourceName, Class<?> caller) {
        URL url;
        URL url2;
        Package callerPackage;
        String resource = resourceName.startsWith("/") ? resourceName.substring(1) : ((callerPackage = caller.getPackage()) != null ? callerPackage.getName().replace('.', '/') + '/' + resourceName : resourceName);
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadClassLoader != null && (url2 = threadClassLoader.getResource(resource)) != null) {
            return url2;
        }
        ClassLoader classLoader = caller.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resource);
    }

    public static List<URL> getResources(String resourcePath, Class<?> caller) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if (classLoader != null) {
            return ClassUtil.toList(classLoader.getResources(resourcePath));
        }
        classLoader = caller.getClassLoader();
        if (classLoader != null) {
            return ClassUtil.toList(classLoader.getResources(resourcePath));
        }
        return new ArrayList<URL>();
    }

    private static <T> List<T> toList(Enumeration<T> objects) {
        ArrayList<T> theList = new ArrayList<T>();
        while (objects.hasMoreElements()) {
            theList.add(objects.nextElement());
        }
        return theList;
    }

    public static String getPath(Package packageObj) {
        return "/" + packageObj.getName().replace('.', '/');
    }

    public static List<String> getResourceList(String regex, Class caller) {
        ClasspathResourceFilter filter = new ClasspathResourceFilter(regex);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof URLClassLoader) {
            filter.filter((URLClassLoader)classLoader);
        }
        if ((classLoader = caller.getClassLoader()) instanceof URLClassLoader) {
            filter.filter((URLClassLoader)classLoader);
        }
        return filter.getResourceList();
    }

    private static class ClasspathResourceFilter {
        private List<String> resourceList = new ArrayList<String>();
        private Pattern pattern;

        private ClasspathResourceFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        private void filter(URLClassLoader classLoader) {
            URL[] cpUrls = classLoader.getURLs();
            for (int i = 0; i < cpUrls.length; ++i) {
                try {
                    File file = new File(cpUrls[i].toURI());
                    if (file.isDirectory()) {
                        this.searchClasspathDirTree(file, "");
                        continue;
                    }
                    this.searchArchive(file);
                    continue;
                }
                catch (URISyntaxException e) {
                    logger.warn("Error searching classpath resource URL '" + cpUrls[i] + "' for resource '" + this.pattern.pattern() + "': " + e.getMessage());
                    continue;
                }
                catch (IOException e) {
                    logger.warn("Error searching classpath resource URL '" + cpUrls[i] + "' for resource '" + this.pattern.pattern() + "': " + e.getMessage());
                }
            }
        }

        private void searchClasspathDirTree(File rootDir, String subDir) {
            File[] contents;
            File currentDir = new File(rootDir, subDir);
            for (File file : contents = currentDir.listFiles()) {
                if (file.isDirectory()) {
                    String subSubDir = subDir + "/" + file.getName();
                    this.searchClasspathDirTree(rootDir, subSubDir);
                    continue;
                }
                String resClasspathPath = file.toURI().toString().substring(rootDir.toURI().toString().length() - 1);
                if (!this.isToBeAdded(resClasspathPath)) continue;
                this.resourceList.add(resClasspathPath);
            }
        }

        private void searchArchive(File archiveFile) throws IOException {
            ZipFile zip = new ZipFile(archiveFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String resClasspathPath = "/" + entry.getName();
                if (!this.isToBeAdded(resClasspathPath)) continue;
                this.resourceList.add(resClasspathPath);
            }
        }

        private boolean isToBeAdded(String resClasspathPath) {
            if (this.resourceList.contains(resClasspathPath)) {
                return false;
            }
            Matcher matcher = this.pattern.matcher(resClasspathPath);
            return matcher.matches();
        }

        private List<String> getResourceList() {
            return this.resourceList;
        }
    }
}

