/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.identification.Usage;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Usage_Type", propOrder={"specificUsage", "usageDate", "userDeterminedLimitations", "userContactInfo"})
@XmlRootElement(name="MD_Usage")
public class DefaultUsage
extends ISOMetadata
implements Usage {
    private static final long serialVersionUID = 7464000583573398579L;
    private InternationalString specificUsage;
    private long usageDate = Long.MIN_VALUE;
    private InternationalString userDeterminedLimitations;
    private Collection<ResponsibleParty> userContactInfo;
    private Collection<InternationalString> responses;
    private Collection<Citation> additionalDocumentation;
    private Collection<Citation> identifiedIssues;

    public DefaultUsage() {
    }

    public DefaultUsage(CharSequence charSequence, ResponsibleParty responsibleParty) {
        this.specificUsage = Types.toInternationalString(charSequence);
        this.userContactInfo = this.singleton(responsibleParty, ResponsibleParty.class);
    }

    public DefaultUsage(Usage usage) {
        super(usage);
        if (usage != null) {
            this.specificUsage = usage.getSpecificUsage();
            this.usageDate = MetadataUtilities.toMilliseconds(usage.getUsageDate());
            this.userDeterminedLimitations = usage.getUserDeterminedLimitations();
            this.userContactInfo = this.copyCollection(usage.getUserContactInfo(), ResponsibleParty.class);
            if (usage instanceof DefaultUsage) {
                DefaultUsage defaultUsage = (DefaultUsage)usage;
                this.responses = this.copyCollection(defaultUsage.getResponses(), InternationalString.class);
                this.additionalDocumentation = this.copyCollection(defaultUsage.getAdditionalDocumentation(), Citation.class);
                this.identifiedIssues = this.copyCollection(defaultUsage.getIdentifiedIssues(), Citation.class);
            }
        }
    }

    public static DefaultUsage castOrCopy(Usage usage) {
        if (usage == null || usage instanceof DefaultUsage) {
            return (DefaultUsage)usage;
        }
        return new DefaultUsage(usage);
    }

    @Override
    @XmlElement(name="specificUsage", required=true)
    public InternationalString getSpecificUsage() {
        return this.specificUsage;
    }

    public void setSpecificUsage(InternationalString internationalString) {
        this.checkWritePermission();
        this.specificUsage = internationalString;
    }

    @Override
    @XmlElement(name="usageDateTime")
    public Date getUsageDate() {
        return MetadataUtilities.toDate(this.usageDate);
    }

    public void setUsageDate(Date date) {
        this.checkWritePermission();
        this.usageDate = MetadataUtilities.toMilliseconds(date);
    }

    @Override
    @XmlElement(name="userDeterminedLimitations")
    public InternationalString getUserDeterminedLimitations() {
        return this.userDeterminedLimitations;
    }

    public void setUserDeterminedLimitations(InternationalString internationalString) {
        this.checkWritePermission();
        this.userDeterminedLimitations = internationalString;
    }

    @XmlElement(name="userContactInfo", required=true)
    public Collection<ResponsibleParty> getUserContactInfo() {
        this.userContactInfo = this.nonNullCollection(this.userContactInfo, ResponsibleParty.class);
        return this.userContactInfo;
    }

    public void setUserContactInfo(Collection<? extends ResponsibleParty> collection) {
        this.userContactInfo = this.writeCollection(collection, this.userContactInfo, ResponsibleParty.class);
    }

    @UML(identifier="response", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends InternationalString> getResponses() {
        this.responses = this.nonNullCollection(this.responses, InternationalString.class);
        return this.responses;
    }

    public void setResponses(Collection<? extends InternationalString> collection) {
        this.responses = this.writeCollection(collection, this.responses, InternationalString.class);
    }

    @UML(identifier="additionalDocumentation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getAdditionalDocumentation() {
        this.additionalDocumentation = this.nonNullCollection(this.additionalDocumentation, Citation.class);
        return this.additionalDocumentation;
    }

    public void setAdditionalDocumentation(Collection<? extends Citation> collection) {
        this.additionalDocumentation = this.writeCollection(collection, this.additionalDocumentation, Citation.class);
    }

    @UML(identifier="identifiedIssues", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Citation> getIdentifiedIssues() {
        this.identifiedIssues = this.nonNullCollection(this.identifiedIssues, Citation.class);
        return this.identifiedIssues;
    }

    public void setIdentifiedIssues(Collection<? extends Citation> collection) {
        this.identifiedIssues = this.writeCollection(collection, this.identifiedIssues, Citation.class);
    }
}

