/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationEditor;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationEditorPopup;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactFieldEditor;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldEditorPopup;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.ModelNameHelper;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.util.AddButton;

public class FactFieldsEditor
extends Composite {
    private static FactFieldsEditorBinder uiBinder = (FactFieldsEditorBinder)GWT.create(FactFieldsEditorBinder.class);
    @UiField
    VerticalPanel fieldsPanel;
    @UiField
    AddButton addFieldIcon;
    @UiField
    AddButton addAnnotationIcon;
    private final ModelNameHelper modelNameHelper;
    private final List<FieldMetaModel> fields;
    private final List<AnnotationMetaModel> annotations;

    public FactFieldsEditor(List<FieldMetaModel> fields, List<AnnotationMetaModel> annotations, ModelNameHelper modelNameHelper) {
        this.fields = fields;
        this.annotations = annotations;
        this.modelNameHelper = modelNameHelper;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.addAnnotationRows();
        this.addFieldRows();
        this.addFieldIcon.setTitle(Constants.INSTANCE.AddField());
        this.addFieldIcon.setText(Constants.INSTANCE.AddField());
        this.addAnnotationIcon.setTitle(Constants.INSTANCE.AddAnnotation());
        this.addAnnotationIcon.setText(Constants.INSTANCE.AddAnnotation());
    }

    @UiHandler(value={"addFieldIcon"})
    void addNewFieldClick(ClickEvent event) {
        final FieldEditorPopup popup = new FieldEditorPopup(this.fields, this.modelNameHelper);
        popup.setOkCommand(new Command(){

            public void execute() {
                this.createNewField(popup);
            }

            private void createNewField(FieldEditorPopup popup2) {
                FieldMetaModel field = popup2.getField();
                FactFieldsEditor.this.fields.add(field);
                FactFieldsEditor.this.addFieldRow(field);
            }
        });
        popup.show();
    }

    @UiHandler(value={"addAnnotationIcon"})
    void addNewAnnotationClick(ClickEvent event) {
        final AnnotationEditorPopup popup = new AnnotationEditorPopup(this.annotations);
        popup.setOkCommand(new Command(){

            public void execute() {
                this.createNewAnnotation(popup);
            }

            private void createNewAnnotation(AnnotationEditorPopup popup2) {
                AnnotationMetaModel annotation = popup2.getAnnotation();
                FactFieldsEditor.this.annotations.add(annotation);
                FactFieldsEditor.this.addAnnotationRow(annotation);
            }
        });
        popup.show();
    }

    private void addFieldRows() {
        for (FieldMetaModel fieldMetaModel : this.fields) {
            this.addFieldRow(fieldMetaModel);
        }
    }

    private void addAnnotationRows() {
        for (AnnotationMetaModel annotation : this.annotations) {
            this.addAnnotationRow(annotation);
        }
    }

    private void addFieldRow(final FieldMetaModel field) {
        final FactFieldEditor editor = new FactFieldEditor(field, this.fields, this.modelNameHelper);
        editor.setDeleteCommand(new Command(){

            public void execute() {
                if (Window.confirm((String)Constants.INSTANCE.AreYouSureYouWantToRemoveTheField0(field.name))) {
                    FactFieldsEditor.this.fieldsPanel.remove((Widget)editor);
                    FactFieldsEditor.this.fields.remove(field);
                }
            }
        });
        this.fieldsPanel.add((Widget)editor);
    }

    private void addAnnotationRow(final AnnotationMetaModel annotation) {
        final AnnotationEditor editor = new AnnotationEditor(annotation, this.annotations);
        editor.setDeleteCommand(new Command(){

            public void execute() {
                if (Window.confirm((String)Constants.INSTANCE.AreYouSureYouWantToRemoveTheAnnotation0(annotation.name))) {
                    FactFieldsEditor.this.fieldsPanel.remove((Widget)editor);
                    FactFieldsEditor.this.annotations.remove(annotation);
                }
            }
        });
        this.fieldsPanel.insert((Widget)editor, this.findPositionOfLastAnnotation());
    }

    private int findPositionOfLastAnnotation() {
        Widget w;
        int position = 0;
        for (int i = 0; i < this.fieldsPanel.getWidgetCount() && !((w = this.fieldsPanel.getWidget(i)) instanceof FactFieldEditor); ++i) {
            position = i + 1;
        }
        return position;
    }

    static interface FactFieldsEditorBinder
    extends UiBinder<Widget, FactFieldsEditor> {
    }
}

