/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates;

import com.google.gwt.cell.client.Cell;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataCellValueFactory;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataColumn;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellTableDropDownDataValueMapProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.templates.InterpolationVariable;
import org.drools.ide.common.client.modeldriven.brl.templates.RuleModelPeerVariableVisitor;
import org.drools.ide.common.client.modeldriven.brl.templates.TemplateModel;

public class TemplateDropDownManager
implements CellTableDropDownDataValueMapProvider {
    private final SuggestionCompletionEngine sce;
    private final TemplateModel model;
    private final TemplateDataCellValueFactory cellValueFactory;
    private DynamicData data;

    public TemplateDropDownManager(TemplateModel model, SuggestionCompletionEngine sce) {
        if (model == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        if (sce == null) {
            throw new IllegalArgumentException("sce cannot be null");
        }
        this.cellValueFactory = new TemplateDataCellValueFactory(model, sce);
        this.model = model;
        this.sce = sce;
    }

    public TemplateDropDownManager(TemplateModel model, DynamicData data, SuggestionCompletionEngine sce) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        if (sce == null) {
            throw new IllegalArgumentException("sce cannot be null");
        }
        this.cellValueFactory = new TemplateDataCellValueFactory(model, sce);
        this.model = model;
        this.data = data;
        this.sce = sce;
    }

    @Override
    public void setData(DynamicData data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.data = data;
    }

    @Override
    public Map<String, String> getCurrentValueMap(Cell.Context context) {
        HashMap<String, String> currentValueMap = new HashMap<String, String>();
        int iBaseRowIndex = context.getIndex();
        int iBaseColIndex = context.getColumn();
        InterpolationVariable[] allVariables = this.model.getInterpolationVariablesList();
        InterpolationVariable baseVariable = allVariables[iBaseColIndex];
        String baseVariableName = baseVariable.getVarName();
        RuleModelPeerVariableVisitor peerVariableVisitor = new RuleModelPeerVariableVisitor((RuleModel)this.model, baseVariableName);
        List peerVariables = peerVariableVisitor.getPeerVariables();
        for (RuleModelPeerVariableVisitor.ValueHolder valueHolder : peerVariables) {
            switch (valueHolder.getType()) {
                case TEMPLATE_KEY: {
                    int iCol = this.getVariableColumnIndex(valueHolder.getValue());
                    InterpolationVariable variable = allVariables[iCol];
                    String field = variable.getFactField();
                    CellValue<? extends Comparable<?>> cv = this.data.get(iBaseRowIndex).get(iCol);
                    TemplateDataColumn column = this.cellValueFactory.makeModelColumn(variable);
                    String value = this.cellValueFactory.convertToModelCell(column, cv);
                    currentValueMap.put(field, value);
                    break;
                }
                case VALUE: {
                    currentValueMap.put(valueHolder.getFieldName(), valueHolder.getValue());
                }
            }
        }
        return currentValueMap;
    }

    private int getVariableColumnIndex(String variableName) {
        InterpolationVariable[] allVariables = this.model.getInterpolationVariablesList();
        for (int iCol = 0; iCol < allVariables.length; ++iCol) {
            InterpolationVariable var = allVariables[iCol];
            if (!var.getVarName().equals(variableName)) continue;
            return iCol;
        }
        throw new IllegalArgumentException("Variable '" + variableName + "' not found. This suggests an programming error.");
    }

    @Override
    public Set<Integer> getDependentColumnIndexes(Cell.Context context) {
        int iBaseColIndex = context.getColumn();
        HashSet<Integer> dependentColumnIndexes = new HashSet<Integer>();
        InterpolationVariable[] allVariables = this.model.getInterpolationVariablesList();
        InterpolationVariable baseVariable = allVariables[iBaseColIndex];
        String baseVariableName = baseVariable.getVarName();
        RuleModelPeerVariableVisitor peerVariableVisitor = new RuleModelPeerVariableVisitor((RuleModel)this.model, baseVariableName);
        List peerVariables = peerVariableVisitor.getPeerVariables();
        for (RuleModelPeerVariableVisitor.ValueHolder valueHolder : peerVariables) {
            switch (valueHolder.getType()) {
                case TEMPLATE_KEY: {
                    int iCol = this.getVariableColumnIndex(valueHolder.getValue());
                    InterpolationVariable variable = allVariables[iCol];
                    String field = variable.getFactField();
                    if (!this.sce.isDependentEnum(baseVariable.getFactType(), baseVariable.getFactField(), field)) break;
                    dependentColumnIndexes.add(iCol);
                }
            }
        }
        return dependentColumnIndexes;
    }
}

