/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk7;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.internal.jdk7.AutoCloseable;

public final class JDK7 {
    private JDK7() {
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    public static boolean isBmpCodePoint(int n) {
        return n >= 0 && n <= 65535;
    }

    public static char highSurrogate(int n) {
        n -= 65536;
        n >>>= 10;
        return (char)(n += 55296);
    }

    public static char lowSurrogate(int n) {
        n &= 0x3FF;
        return (char)(n += 56320);
    }

    public static boolean isAutoCloseable(Object object) {
        return object instanceof AutoCloseable || object instanceof Closeable || object instanceof ImageInputStream || object instanceof Connection || object instanceof Statement || object instanceof ResultSet;
    }

    public static void close(Object object) throws Exception {
        if (object instanceof Closeable) {
            ((Closeable)object).close();
        } else if (object instanceof ImageInputStream) {
            ((ImageInputStream)object).close();
        } else if (object instanceof Connection) {
            ((Connection)object).close();
        } else if (object instanceof Statement) {
            ((Statement)object).close();
        } else if (object instanceof ResultSet) {
            ((ResultSet)object).close();
        } else {
            ((AutoCloseable)object).close();
        }
    }
}

