/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk7;

import java.util.Arrays;

public final class Objects {
    private Objects() {
    }

    public static <T> T requireNonNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T> T requireNonNull(T t, String string) {
        if (t == null) {
            throw new NullPointerException(string);
        }
        return t;
    }

    public static boolean equals(Object object, Object object2) {
        assert (object == null || !object.getClass().isArray()) : object;
        assert (object2 == null || !object2.getClass().isArray()) : object2;
        return object == object2 || object != null && object.equals(object2);
    }

    public static boolean deepEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof Object[]) {
            return object2 instanceof Object[] && Arrays.deepEquals((Object[])object, (Object[])object2);
        }
        if (object instanceof double[]) {
            return object2 instanceof double[] && Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[]) {
            return object2 instanceof float[] && Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof long[]) {
            return object2 instanceof long[] && Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof int[]) {
            return object2 instanceof int[] && Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof short[]) {
            return object2 instanceof short[] && Arrays.equals((short[])object, (short[])object2);
        }
        if (object instanceof byte[]) {
            return object2 instanceof byte[] && Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[]) {
            return object2 instanceof char[] && Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof boolean[]) {
            return object2 instanceof boolean[] && Arrays.equals((boolean[])object, (boolean[])object2);
        }
        return object.equals(object2);
    }

    public static int hash(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        assert (!object.getClass().isArray()) : object;
        return object.hashCode();
    }
}

