/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.jcrExport;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryModuleService;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.ModuleIterator;
import org.drools.repository.RulesRepository;
import org.drools.workbench.jcr2vfsmigration.common.FileManager;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.AttachmentAssetExporter;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.ExportContext;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.FactModelExporter;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.GuidedDecisionTableExporter;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.GuidedEditorExporter;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.PlainTextAssetExporter;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.PlainTextAssetWithPackagePropertyExporter;
import org.drools.workbench.jcr2vfsmigration.util.ExportUtils;
import org.drools.workbench.jcr2vfsmigration.xml.format.ModulesXmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlAssetsFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.ModuleType;
import org.drools.workbench.jcr2vfsmigration.xml.model.Modules;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.IgnoredAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAssets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleAssetExporter {
    private static final Logger logger = LoggerFactory.getLogger(ModuleAssetExporter.class);
    private static int assetFileName = 1;
    private static final String GLOBAL_KEYWORD = "global ";
    @Inject
    private FileManager fileManager;
    @Inject
    private ExportUtils exportUtils;
    @Inject
    private RepositoryModuleService jcrRepositoryModuleService;
    @Inject
    private RepositoryAssetService jcrRepositoryAssetService;
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    private PlainTextAssetExporter plainTextAssetExporter;
    @Inject
    private PlainTextAssetWithPackagePropertyExporter plainTextAssetWithPackagePropertyExporter;
    @Inject
    private GuidedEditorExporter guidedEditorExporter;
    @Inject
    private GuidedDecisionTableExporter guidedDecisionTableExporter;
    @Inject
    private FactModelExporter factModelExporter;
    @Inject
    private AttachmentAssetExporter attachmentAssetExporter;
    private ModulesXmlFormat modulesXmlFormat = new ModulesXmlFormat();
    private XmlAssetsFormat xmlAssetsFormat = new XmlAssetsFormat();

    public void exportAll() {
        logger.info("  Module export started");
        Module jcrGlobalModule = this.jcrRepositoryModuleService.loadGlobalModule();
        Module[] jcrModules = this.jcrRepositoryModuleService.listModules();
        if (jcrGlobalModule == null && jcrModules.length == 0) {
            logger.info("  No modules to be exported");
            return;
        }
        ArrayList<org.drools.workbench.jcr2vfsmigration.xml.model.Module> normalModules = new ArrayList<org.drools.workbench.jcr2vfsmigration.xml.model.Module>(5);
        for (Module jcrModule : jcrModules) {
            normalModules.add(this.export(ModuleType.NORMAL, jcrModule));
        }
        org.drools.workbench.jcr2vfsmigration.xml.model.Module globalModule = this.export(ModuleType.GLOBAL, jcrGlobalModule);
        Modules modules = new Modules(globalModule, normalModules);
        StringBuilder xml = new StringBuilder();
        this.modulesXmlFormat.format(xml, modules);
        PrintWriter pw = this.fileManager.createModuleExportFileWriter();
        pw.print(xml.toString());
        pw.close();
        logger.info("  Module export ended");
    }

    private org.drools.workbench.jcr2vfsmigration.xml.model.Module export(ModuleType moduleType, Module jcrModule) {
        String assetExportFileName;
        boolean assetExportSuccess;
        logger.info("    Exporting module [{}] (UUID={}).", (Object)jcrModule.getName(), (Object)jcrModule.getUuid());
        ModuleIterator packageItems = this.rulesRepository.listModules();
        while (packageItems.hasNext()) {
            ModuleItem packageItem = packageItems.next();
            if (!packageItem.getUUID().equals(jcrModule.getUuid())) continue;
            jcrModule.setCatRules(packageItem.getCategoryRules());
            break;
        }
        String moduleName = jcrModule.getName();
        String normalizedPackageName = this.exportUtils.normalizePackageName(jcrModule.getName());
        jcrModule.setName(normalizedPackageName);
        String packageHeaderInfo = null;
        try {
            ArrayList<String> formats = new ArrayList<String>();
            formats.add("package");
            AssetPageRequest request = new AssetPageRequest(jcrModule.getUuid(), formats, null, 0, Integer.valueOf(10));
            PageResponse response = this.jcrRepositoryAssetService.findAssetPage(request);
            if (response.getTotalRowSize() > 0) {
                AssetPageRow row = (AssetPageRow)response.getPageRowList().get(0);
                AssetItem assetItemJCR = this.rulesRepository.loadAssetByUUID(row.getUuid());
                packageHeaderInfo = assetItemJCR.getContent();
            }
        }
        catch (SerializationException e) {
            throw new IllegalStateException(e);
        }
        StringBuffer sbGlobal = new StringBuffer();
        List<String> lGlobals = ExportUtils.parseGlobals(packageHeaderInfo);
        if (lGlobals.size() > 0) {
            for (String global : lGlobals) {
                sbGlobal.append(GLOBAL_KEYWORD);
                sbGlobal.append(global);
                sbGlobal.append("\n");
            }
        }
        if (!(assetExportSuccess = this.exportModuleAssets(jcrModule, assetExportFileName = this.setupAssetExportFile(jcrModule.getUuid())))) {
            logger.error("An error occurred during asset export for module {} (UUID={})!", (Object)jcrModule.getName(), (Object)jcrModule.getUuid());
        }
        return new org.drools.workbench.jcr2vfsmigration.xml.model.Module(moduleType, jcrModule.getUuid(), moduleName, jcrModule.getLastContributor(), jcrModule.getCheckinComment(), jcrModule.getLastModified(), normalizedPackageName, packageHeaderInfo, sbGlobal.toString(), (Map)jcrModule.getCatRules(), assetExportFileName);
    }

    private boolean exportModuleAssets(Module jcrModule, String assetFileName) {
        PrintWriter pw;
        ArrayList<XmlAsset> assets = new ArrayList<XmlAsset>(10);
        StringBuilder xml = new StringBuilder();
        try {
            pw = this.fileManager.createAssetExportFileWriter(assetFileName);
        }
        catch (FileNotFoundException e) {
            logger.error("Can't find file for {}!", (Object)assetFileName, (Object)e);
            return false;
        }
        boolean hasMorePages = true;
        int startRowIndex = 0;
        int pageSize = 100;
        while (hasMorePages) {
            PageResponse response;
            AssetPageRequest request = new AssetPageRequest(jcrModule.getUuid(), null, null, startRowIndex, Integer.valueOf(100));
            String assetName = "";
            try {
                response = this.jcrRepositoryAssetService.findAssetPage(request);
                for (AssetPageRow row : response.getPageRowList()) {
                    AssetItem assetItemJCR = this.rulesRepository.loadAssetByUUID(row.getUuid());
                    assetName = assetItemJCR.getName();
                    boolean isDisabled = assetItemJCR.getDisabled();
                    if (isDisabled) {
                        logger.info("      Ignoring disabled asset [{}.{}].", (Object)assetItemJCR.getName(), (Object)assetItemJCR.getFormat());
                        continue;
                    }
                    logger.info("      Exporting asset [{}.{}].", (Object)assetItemJCR.getName(), (Object)assetItemJCR.getFormat());
                    XmlAsset xmlAsset = this.export(ExportContext.create(jcrModule, assetItemJCR, assetFileName));
                    xmlAsset.setAssetHistory(this.exportAssetHistory(ExportContext.create(jcrModule, row.getUuid(), assetFileName)));
                    assets.add(xmlAsset);
                }
            }
            catch (SerializationException e) {
                logger.error("SerializationException exporting asset {} from module {}!", new Object[]{assetName, jcrModule.getName(), e});
                return false;
            }
            catch (Exception e) {
                logger.error("Exception exporting asset {} from module {}!", new Object[]{assetName, jcrModule.getName(), e});
                return false;
            }
            if (response.isLastPage()) {
                hasMorePages = false;
                continue;
            }
            startRowIndex += 100;
        }
        this.xmlAssetsFormat.format(xml, new XmlAssets(assets));
        pw.print(xml.toString());
        pw.close();
        return true;
    }

    private XmlAsset export(ExportContext exportContext) {
        String name = exportContext.getJcrAssetItem().getName();
        String format = exportContext.getJcrAssetItem().getFormat();
        if ("model.drl".equals(format)) {
            return this.factModelExporter.export(exportContext);
        }
        if ("brl".equals(format)) {
            return this.guidedEditorExporter.export(exportContext);
        }
        if ("gdst".equals(format)) {
            return this.guidedDecisionTableExporter.export(exportContext);
        }
        if ("enumeration".equals(format) || "dsl".equals(format) || "dslr".equals(format) || "template".equals(format) || "formdef".equals(format) || "springContext".equals(format) || "serviceConfig".equals(format) || "wid".equals(format) || "changeset".equals(format) || "rf".equals(format) || "bpmn".equals(format) || "bpmn2".equals(format) || "ftl".equals(format) || "json".equals(format) || "fw".equals(format)) {
            return this.plainTextAssetExporter.export(exportContext);
        }
        if ("drl".equals(format) || "function".equals(format)) {
            return this.plainTextAssetWithPackagePropertyExporter.export(exportContext);
        }
        if ("xls".equals(format) || "scxls".equals(format) || "png".equals(format) || "gif".equals(format) || "jpg".equals(format) || "pdf".equals(format) || "doc".equals(format) || "odt".equals(format)) {
            return this.attachmentAssetExporter.export(exportContext);
        }
        if ("jar".equals(format)) {
            logger.warn("        POJO Model jar [{}] is not supported by export tool. Please add your POJO model jar to Guvnor manually.", (Object)name);
            return new IgnoredAsset();
        }
        if ("scgd".equals(format)) {
            return this.plainTextAssetExporter.export(exportContext);
        }
        if ("scenario".equals(format)) {
            return this.plainTextAssetExporter.export(exportContext);
        }
        if ("package".equals(format)) {
            return new IgnoredAsset();
        }
        logger.warn("        Asset [{}.{}] is not a known format by export tool. It will be exported as attachmentAsset", (Object)name, (Object)format);
        return this.attachmentAssetExporter.export(exportContext);
    }

    private XmlAssets exportAssetHistory(ExportContext historyContext) throws SerializationException {
        XmlAssets xmlAssets = new XmlAssets();
        String currentVersionAssetName = "";
        try {
            TableDataResult history = this.jcrRepositoryAssetService.loadItemHistory(historyContext.getAssetUUID());
            TableDataRow[] rows = history.data;
            Arrays.sort(rows, new Comparator<TableDataRow>(){

                @Override
                public int compare(TableDataRow r1, TableDataRow r2) {
                    Integer v2 = Integer.valueOf(r2.values[0]);
                    Integer v1 = Integer.valueOf(r1.values[0]);
                    return v1.compareTo(v2);
                }
            });
            String historicalAssetExportFileName = "h_" + historyContext.getAssetExportFileName();
            for (TableDataRow row : rows) {
                AssetItem historicalAssetJCR = this.rulesRepository.loadAssetByUUID(row.id);
                currentVersionAssetName = historicalAssetJCR.getName();
                ExportContext historicalAssetExportContext = ExportContext.create(historyContext.getJcrModule(), historicalAssetJCR, historicalAssetExportFileName);
                xmlAssets.addAsset(this.export(historicalAssetExportContext));
                logger.info("    Asset [{}.{}] migrated: version [{}], comment [{}], lastModified [{}]", new Object[]{historicalAssetJCR.getName(), historicalAssetJCR.getFormat(), historicalAssetJCR.getVersionNumber(), historicalAssetJCR.getCheckinComment(), historicalAssetJCR.getLastModified().getTime()});
            }
        }
        catch (RuntimeException e) {
            logger.error("Exception migrating assetHistory at version {} from module {}!", (Object)currentVersionAssetName, (Object)historyContext.getJcrModule().getName());
        }
        return xmlAssets;
    }

    private String setupAssetExportFile(String moduleUuid) {
        StringBuilder fileNameBuilder = new StringBuilder();
        boolean success = false;
        if (StringUtils.isNotBlank((CharSequence)moduleUuid)) {
            fileNameBuilder.insert(0, moduleUuid);
            success = this.fileManager.createAssetExportFile(fileNameBuilder.toString());
        }
        if (!success) {
            fileNameBuilder.replace(0, fileNameBuilder.lastIndexOf("."), Integer.toString(assetFileName++));
            success = this.fileManager.createAssetExportFile(fileNameBuilder.toString());
            if (!success) {
                logger.error("Module asset file could not be created");
                return null;
            }
        }
        return fileNameBuilder.toString();
    }
}

