/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class PrettyFormLayout
extends Composite {
    private VerticalPanel layout = new VerticalPanel();
    private FlexTable currentTable;
    private String sectionName;

    public PrettyFormLayout() {
        this.layout.setWidth("100%");
        this.initWidget((Widget)this.layout);
    }

    public void startSection() {
        this.currentTable = new FlexTable();
    }

    public void startSection(String title) {
        this.startSection();
        this.sectionName = title;
    }

    public void clear() {
        this.layout.clear();
    }

    public void addHeader(Image img, String name, Image edit) {
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)img);
        h.add((Widget)new HTML("&nbsp;"));
        h.add((Widget)new Label(name));
        if (edit != null) {
            h.add((Widget)edit);
        }
        FormPanel f = this.newForm(null);
        f.add((Widget)h);
        this.layout.add((Widget)f);
    }

    public void addHeader(Image img, Widget content) {
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)img);
        h.add((Widget)new HTML("&nbsp;"));
        h.add(content);
        FormPanel f = this.newForm(null);
        f.add((Widget)h);
        this.layout.add((Widget)f);
    }

    private FormPanel newForm(String hdr) {
        FormPanel fp = new FormPanel();
        fp.setWidth("100%");
        fp.addStyleName("guvnor-FormPanel");
        if (hdr != null) {
            fp.setTitle(hdr);
        }
        return fp;
    }

    public void endSection() {
        FormPanel f = this.newForm(this.sectionName);
        f.add((Widget)this.currentTable);
        this.layout.add((Widget)f);
        this.sectionName = null;
    }

    public void addRow(Widget widget) {
        int row = this.currentTable.getRowCount();
        this.currentTable.setWidget(row, 0, widget);
        this.currentTable.getFlexCellFormatter().setColSpan(row, 0, 2);
    }

    public int addAttribute(String lbl, Widget categories) {
        String id = DOM.createUniqueId();
        categories.getElement().setAttribute("aria-labelledby", id);
        categories.getElement().setAttribute("aria-required", String.valueOf(true));
        categories.getElement().setTabIndex(0);
        int row = this.currentTable.getRowCount();
        Label label = new Label(lbl);
        label.getElement().setAttribute("id", id);
        this.currentTable.setWidget(row, 0, (Widget)label);
        this.currentTable.setWidget(row, 1, categories);
        this.currentTable.getFlexCellFormatter().setHorizontalAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        this.currentTable.getFlexCellFormatter().setVerticalAlignment(row, 0, HasVerticalAlignment.ALIGN_TOP);
        return row;
    }

    public void removeRow(int row) {
        this.currentTable.removeRow(row);
    }
}

