/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.browse;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.IsTreeItem;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.browse.BrowseTreeView;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.util.Util;

public class BrowseTreeViewImpl
extends Composite
implements BrowseTreeView {
    private static ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private TreeItem root;
    private TreeItem states;
    private TreeItem inbox;
    private static BrowseTreeViewImplBinder uiBinder = (BrowseTreeViewImplBinder)GWT.create(BrowseTreeViewImplBinder.class);
    private BrowseTreeView.Presenter presenter;
    @UiField
    DockLayoutPanel layout;
    @UiField
    Tree tree;

    public BrowseTreeViewImpl(ClientFactory clientFactory) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.addSelectionHandler();
        this.addOpenHandler();
        this.inbox = this.tree.addItem(Util.getHeader(images.inbox(), constants.Inbox()));
    }

    private void addSelectionHandler() {
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> treeItemSelectionEvent) {
                TreeItem selectedItem = (TreeItem)treeItemSelectionEvent.getSelectedItem();
                BrowseTreeViewImpl.this.presenter.onTreeItemSelection((IsTreeItem)selectedItem, selectedItem.getText());
            }
        });
    }

    private void addOpenHandler() {
        this.tree.addOpenHandler((OpenHandler)new OpenHandler<TreeItem>(){

            public void onOpen(OpenEvent<TreeItem> treeItemOpenEvent) {
                BrowseTreeViewImpl.this.presenter.onTreeItemOpen((IsTreeItem)treeItemOpenEvent.getTarget());
            }
        });
    }

    @Override
    public void setPresenter(BrowseTreeView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public IsTreeItem addRootTreeItem() {
        this.root = this.tree.addItem(Util.getHeader(images.ruleAsset(), constants.AssetsTreeView()));
        return this.root;
    }

    @Override
    public IsTreeItem addInboxIncomingTreeItem() {
        return this.inbox.addItem(Util.getHeader(images.categorySmall(), this.getInboxIncomingName()));
    }

    @Override
    public IsTreeItem addInboxRecentEditedTreeItem() {
        return this.inbox.addItem(Util.getHeader(images.categorySmall(), this.getInboxRecentEditedName()));
    }

    @Override
    public IsTreeItem addInboxRecentViewedTreeItem() {
        return this.inbox.addItem(Util.getHeader(images.categorySmall(), this.getInboxRecentViewedName()));
    }

    @Override
    public String getInboxIncomingName() {
        return constants.IncomingChanges();
    }

    @Override
    public String getInboxRecentEditedName() {
        return constants.RecentlyEdited();
    }

    @Override
    public String getInboxRecentViewedName() {
        return constants.RecentlyOpened();
    }

    @Override
    public Collection<IsTreeItem> getChildren(IsTreeItem openedItem) {
        ArrayList<IsTreeItem> children = new ArrayList<IsTreeItem>();
        TreeItem parent = openedItem.asTreeItem();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            children.add((IsTreeItem)parent.getChild(i));
        }
        return children;
    }

    @Override
    public IsTreeItem addFind() {
        return this.root.addItem(Util.getHeader(images.find(), constants.Find()));
    }

    @Override
    public IsTreeItem addRootStateTreeItem() {
        this.states = this.root.addItem(Util.getHeader(images.statusSmall(), constants.ByStatus()));
        return this.states;
    }

    @Override
    public IsTreeItem addRootCategoryTreeItem() {
        return this.root.addItem(Util.getHeader(images.chartOrganisation(), constants.ByCategory()));
    }

    @Override
    public IsTreeItem addTreeItem(IsTreeItem parent, String name) {
        return parent.asTreeItem().addItem(name);
    }

    @Override
    public void removeStates() {
        this.states.removeItems();
    }

    @Override
    public IsTreeItem addStateItem(String state) {
        return this.states.addItem(state);
    }

    @Override
    public void removeCategories(IsTreeItem treeItem) {
        treeItem.asTreeItem().removeItems();
    }

    static interface BrowseTreeViewImplBinder
    extends UiBinder<Widget, BrowseTreeViewImpl> {
    }
}

